/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SRenderingElementContainer;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharSet;
import org.w3c.dom.Node;

public class SCitationLayout
extends SRenderingElementContainer {
    private static final CharSet PUNCTUATION_END = CharSet.getInstance((String[])new String[]{":.,;!?)]&"});
    private static final CharSet PUNCTUATION_START = CharSet.getInstance((String[])new String[]{"([&"});
    private static final Pattern TRIM_END = Pattern.compile("\\p{Space}+$");
    private static final Pattern IGNORE_END = Pattern.compile("[\\p{Space}\\p{Pf}\"']+$");
    private final Affixes affixes;
    private final int formattingAttributes;
    private final String delimiter;

    public SCitationLayout(Node node) {
        super(node);
        this.affixes = new Affixes(node);
        this.formattingAttributes = FormattingAttributes.of(node);
        this.delimiter = NodeHelper.getAttrValue(node, "delimiter");
    }

    @Override
    public void render(RenderContext ctx) {
        this.affixes.wrap(this::renderInternal).accept(ctx);
    }

    private void renderInternal(RenderContext ctx) {
        RenderContext tmp = new RenderContext(ctx);
        for (CSLCitationItem item : ctx.getCitation().getCitationItems()) {
            RenderContext innerTmp = new RenderContext(ctx, item);
            innerTmp.reset();
            super.render(innerTmp);
            if (this.delimiter != null && !tmp.getResult().isEmpty()) {
                tmp.emit(this.delimiter, Token.Type.DELIMITER);
            }
            if (item.getPrefix() != null) {
                String prefix = item.getPrefix();
                if (SCitationLayout.needsAppendSpace(prefix)) {
                    prefix = TRIM_END.matcher(prefix).replaceAll("") + " ";
                }
                tmp.emit(prefix, Token.Type.PREFIX);
            }
            tmp.emit(innerTmp.getResult());
            if (item.getSuffix() == null) continue;
            String suffix = item.getSuffix();
            if (SCitationLayout.needsPrependSpace(suffix)) {
                suffix = " " + suffix;
            }
            tmp.emit(suffix, Token.Type.SUFFIX);
        }
        ctx.emit(tmp.getResult(), this.formattingAttributes);
    }

    private static boolean needsAppendSpace(String prefix) {
        if (prefix.isEmpty()) {
            return false;
        }
        char c = (prefix = IGNORE_END.matcher(prefix).replaceAll("")).charAt(prefix.length() - 1);
        return Character.isLetterOrDigit(c) || PUNCTUATION_END.contains(c);
    }

    private static boolean needsPrependSpace(String suffix) {
        if (suffix.isEmpty()) {
            return false;
        }
        char c = suffix.charAt(0);
        return Character.isLetterOrDigit(c) || PUNCTUATION_START.contains(c);
    }
}

