/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.bibtex.PageParser;
import de.undercouch.citeproc.bibtex.PageRange;
import de.undercouch.citeproc.csl.CSLLabel;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.StripPeriods;
import de.undercouch.citeproc.csl.internal.behavior.TextCase;
import de.undercouch.citeproc.csl.internal.helper.NumberElement;
import de.undercouch.citeproc.csl.internal.helper.NumberParser;
import de.undercouch.citeproc.csl.internal.locale.LTerm;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.List;
import org.w3c.dom.Node;

public class SLabel
implements SRenderingElement {
    private final String variable;
    private final String form;
    private final Affixes affixes;
    private final TextCase textCase;
    private final StripPeriods stripPeriods;

    public SLabel(Node node) {
        this(node, NodeHelper.getAttrValue(node, "variable"));
    }

    public SLabel(Node node, String variable) {
        this.variable = variable;
        String form = NodeHelper.getAttrValue(node, "form");
        if (form == null) {
            form = "long";
        }
        this.form = form;
        this.affixes = new Affixes(node);
        this.textCase = new TextCase(node);
        this.stripPeriods = new StripPeriods(node);
    }

    @Override
    public void render(RenderContext ctx) {
        this.render(ctx, 0);
    }

    public void render(RenderContext ctx, int nNumberElement) {
        this.affixes.wrap(this.textCase.wrap(this.stripPeriods.wrap(ctx2 -> this.renderInternal((RenderContext)ctx2, nNumberElement)))).accept(ctx);
    }

    private void renderInternal(RenderContext ctx, int nNumberElement) {
        NumberElement element;
        List<NumberElement> elements;
        if (this.variable == null || this.variable.isEmpty()) {
            return;
        }
        Object value = ctx.getVariable(this.variable);
        if (value == null) {
            return;
        }
        String term = this.variable;
        boolean plural = false;
        boolean isLocator = false;
        if (this.variable.equals("page")) {
            PageRange range = PageParser.parse(String.valueOf(value));
            plural = range.isMultiplePages();
        } else if ((this.variable.equals("number") || (isLocator = this.variable.equals("locator"))) && (elements = NumberParser.parse(String.valueOf(value))).size() > nNumberElement && (element = elements.get(nNumberElement)) != null) {
            if (element.getLabel() != null) {
                term = element.getLabel().toString();
            } else if (nNumberElement == 0 && isLocator) {
                CSLLabel label = null;
                if (ctx.getCitationItem() != null) {
                    label = ctx.getCitationItem().getLabel();
                }
                term = label != null ? label.toString() : "page";
            }
            plural = element.isPlural();
        }
        ctx.setLastLabelRendered(this);
        ctx.emit(ctx.getTerm(term, LTerm.Form.fromString(this.form), plural));
    }
}

