/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SElement;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.helper.NodeHelper;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public class SName
implements SElement {
    public static final int FORM_LONG = 0;
    public static final int FORM_SHORT = 1;
    public static final int FORM_COUNT = 2;
    private final String variable;
    private final String and;
    private final String delimiter;
    private final String delimiterPrecedesEtAl;
    private final String delimiterPrecedesLast;
    private final int form;
    private final String initializeWith;
    private final String nameAsSortOrder;
    private final String sortSeparator;
    private final Integer etAlMin;
    private final Integer etAlUseFirst;
    private final int formattingAttributes;

    public SName(Node node, String variable) {
        String etAlUseFirst;
        String etAlMin;
        String sortSeparator;
        String form;
        String delimiterPrecedesLast;
        String delimiterPrecedesEtAl;
        String delimiter;
        this.variable = variable;
        if (node != null) {
            this.and = NodeHelper.getAttrValue(node, "and");
            this.initializeWith = StringUtils.strip((String)NodeHelper.getAttrValue(node, "initialize-with"));
            this.nameAsSortOrder = NodeHelper.getAttrValue(node, "name-as-sort-order");
            this.formattingAttributes = FormattingAttributes.of(node);
            delimiter = NodeHelper.getAttrValue(node, "delimiter");
            delimiterPrecedesEtAl = NodeHelper.getAttrValue(node, "delimiter-precedes-et-al");
            delimiterPrecedesLast = NodeHelper.getAttrValue(node, "delimiter-precedes-last");
            form = NodeHelper.getAttrValue(node, "form");
            sortSeparator = NodeHelper.getAttrValue(node, "sort-separator");
            etAlMin = NodeHelper.getAttrValue(node, "et-al-min");
            etAlUseFirst = NodeHelper.getAttrValue(node, "et-al-use-first");
        } else {
            this.and = null;
            this.initializeWith = null;
            this.nameAsSortOrder = null;
            this.formattingAttributes = 0;
            delimiter = null;
            delimiterPrecedesEtAl = null;
            delimiterPrecedesLast = null;
            form = null;
            sortSeparator = null;
            etAlMin = null;
            etAlUseFirst = null;
        }
        if (delimiter == null) {
            delimiter = ", ";
        }
        this.delimiter = delimiter;
        if (delimiterPrecedesEtAl == null) {
            delimiterPrecedesEtAl = "contextual";
        }
        this.delimiterPrecedesEtAl = delimiterPrecedesEtAl;
        if (delimiterPrecedesLast == null) {
            delimiterPrecedesLast = "contextual";
        }
        this.delimiterPrecedesLast = delimiterPrecedesLast;
        this.form = "count".equals(form) ? 2 : ("short".equals(form) ? 1 : 0);
        if (sortSeparator == null) {
            sortSeparator = ", ";
        }
        this.sortSeparator = sortSeparator;
        this.etAlMin = etAlMin != null ? Integer.valueOf(Integer.parseInt(etAlMin)) : null;
        this.etAlUseFirst = etAlUseFirst != null ? Integer.valueOf(Integer.parseInt(etAlUseFirst)) : null;
    }

    public String getVariable() {
        return this.variable;
    }

    public int getForm() {
        return this.form;
    }

    @Override
    public void render(RenderContext ctx) {
        CSLName[] names = null;
        if (this.variable != null) {
            names = ctx.getNameVariable(this.variable);
        }
        if (names == null) {
            return;
        }
        String and = "text".equals(this.and) ? " " + ctx.getTerm("and") + " " : ("symbol".equals(this.and) ? " & " : this.delimiter);
        int max = -1;
        if (this.etAlMin != null && this.etAlUseFirst != null && names.length >= this.etAlMin && (max = this.etAlUseFirst.intValue()) == 0) {
            return;
        }
        if (this.form == 2) {
            int count = names.length;
            if (max > -1 && max < count) {
                count = max;
            }
            ctx.emit(String.valueOf(count), this.formattingAttributes);
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            boolean nameAsSort = "all".equals(this.nameAsSortOrder) || i == 0 && "first".equals(this.nameAsSortOrder);
            builder.append(this.render(names[i], nameAsSort));
            if (i >= names.length - 1) continue;
            if (i == max - 1) {
                String etAl = ctx.getTerm("et-al");
                this.appendDelimiter(builder, this.delimiterPrecedesEtAl, i, max > 1);
                this.appendAnd(builder, " " + etAl);
                break;
            }
            if (i == names.length - 2) {
                boolean delimiterAppended = this.appendDelimiter(builder, this.delimiterPrecedesLast, i, names.length > 2);
                if (delimiterAppended && and.equals(this.delimiter)) continue;
                this.appendAnd(builder, and);
                continue;
            }
            builder.append(this.delimiter);
        }
        ctx.emit(builder.toString(), this.formattingAttributes);
    }

    private boolean appendDelimiter(StringBuilder builder, String delimiterPrecedes, int i, boolean contextual) {
        boolean delimiterAppended = false;
        switch (delimiterPrecedes) {
            case "contextual": {
                if (!contextual) break;
                builder.append(this.delimiter);
                delimiterAppended = true;
                break;
            }
            case "always": {
                builder.append(this.delimiter);
                delimiterAppended = true;
                break;
            }
            case "after-inverted-name": {
                if (i != 0) break;
                builder.append(this.delimiter);
                delimiterAppended = true;
                break;
            }
        }
        return delimiterAppended;
    }

    private void appendAnd(StringBuilder builder, String and) {
        if (Character.isWhitespace(builder.charAt(builder.length() - 1)) && Character.isWhitespace(and.charAt(0))) {
            builder.append(and, 1, and.length());
        } else {
            builder.append(and);
        }
    }

    private String render(CSLName name, boolean nameAsSort) {
        String family = name.getFamily();
        if (family != null) {
            if (name.getNonDroppingParticle() != null) {
                family = name.getNonDroppingParticle().trim() + " " + family;
            }
            if (this.form == 1) {
                return family;
            }
            if (name.getDroppingParticle() != null) {
                family = name.getDroppingParticle().trim() + " " + family;
            }
            if (name.getSuffix() != null) {
                family = StringUtils.stripEnd((String)family, null) + " " + name.getSuffix().trim();
            }
        }
        StringBuilder result = new StringBuilder();
        String given = name.getGiven();
        StringBuilder givenBuffer = new StringBuilder();
        if (given != null) {
            if (this.initializeWith != null) {
                boolean found = true;
                boolean hyphen = false;
                for (int i = 0; i < given.length(); ++i) {
                    char c = given.charAt(i);
                    if (c == '-') {
                        found = true;
                        hyphen = true;
                        continue;
                    }
                    if (Character.isWhitespace(c) || c == '.') {
                        found = true;
                        continue;
                    }
                    if (!found) continue;
                    if (givenBuffer.length() > 0) {
                        givenBuffer.append(hyphen ? (char)'-' : ' ');
                    }
                    givenBuffer.append(c).append(this.initializeWith);
                    found = false;
                    hyphen = false;
                }
            } else {
                givenBuffer.append(given);
            }
        }
        if (nameAsSort) {
            if (family != null) {
                result.append(family);
            }
            if (family != null && given != null) {
                result.append(this.sortSeparator);
            }
            if (given != null) {
                result.append((CharSequence)givenBuffer);
            }
        } else {
            if (given != null) {
                result.append((CharSequence)givenBuffer);
            }
            if (given != null && family != null) {
                result.append(" ");
            }
            if (family != null) {
                result.append(family);
            }
        }
        return result.toString();
    }
}

