/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.rendering.SLabel;
import de.undercouch.citeproc.csl.internal.rendering.SName;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.csl.internal.rendering.SSubstitute;
import de.undercouch.citeproc.helper.NodeHelper;
import org.w3c.dom.Node;

public class SNames
implements SRenderingElement {
    private final SName name;
    private final Affixes affixes;
    private final SLabel label;
    private final SSubstitute substitute;

    public SNames(Node node) {
        this(node, NodeHelper.getAttrValue(node, "variable"), true);
    }

    public SNames(Node node, String variable, boolean parseSubstitute) {
        Node substituteNode;
        this.name = new SName(NodeHelper.findDirectChild(node, "name"), variable);
        this.affixes = this.name.getForm() == 2 ? new Affixes() : new Affixes(node);
        Node labelNode = NodeHelper.findDirectChild(node, "label");
        this.label = labelNode != null ? new SLabel(labelNode, variable) : null;
        this.substitute = parseSubstitute ? ((substituteNode = NodeHelper.findDirectChild(node, "substitute")) != null ? new SSubstitute(substituteNode, node) : null) : null;
    }

    public String getVariable() {
        return this.name.getVariable();
    }

    @Override
    public void render(RenderContext ctx) {
        RenderContext tmp = new RenderContext(ctx);
        this.affixes.wrap(this::renderInternal).accept(tmp);
        if (tmp.getResult().isEmpty() && this.substitute != null) {
            this.substitute.render(tmp);
        }
        ctx.emit(tmp.getResult());
    }

    private void renderInternal(RenderContext ctx) {
        if (this.label != null) {
            this.label.render(ctx);
        }
        this.name.render(ctx);
    }
}

