/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.AbbreviationProvider;
import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.DefaultAbbreviationProvider;
import de.undercouch.citeproc.DefaultLocaleProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.LocaleProvider;
import java.io.IOException;

public class CSLBuilder {
    private ItemDataProvider itemDataProvider;
    private LocaleProvider localeProvider = new DefaultLocaleProvider();
    private AbbreviationProvider abbreviationProvider = new DefaultAbbreviationProvider();
    private String style;
    private String lang = "en-US";

    public CSLBuilder itemDataProvider(ItemDataProvider itemDataProvider) {
        this.itemDataProvider = itemDataProvider;
        return this;
    }

    public CSLBuilder localeProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
        return this;
    }

    public CSLBuilder abbreviationProvider(AbbreviationProvider abbreviationProvider) {
        this.abbreviationProvider = abbreviationProvider;
        return this;
    }

    public CSLBuilder style(String style) {
        this.style = style;
        return this;
    }

    public CSLBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public CSL build() throws IOException {
        if (this.itemDataProvider == null) {
            throw new IllegalArgumentException("Cannot construct a CSL object without an ItemDataProvider");
        }
        if (this.style == null) {
            throw new IllegalArgumentException("Cannot construct a CSL object without a citation style");
        }
        return new CSL(this.itemDataProvider, this.localeProvider, this.abbreviationProvider, this.style, this.lang);
    }
}

