/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.internal.CollectingVariableListener;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SKey;
import de.undercouch.citeproc.csl.internal.SStyle;
import de.undercouch.citeproc.csl.internal.locale.LLocale;
import de.undercouch.citeproc.helper.AlphanumComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SSort {
    private final List<SKey> keys = new ArrayList<SKey>();

    public SSort(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            String nodeName = c.getNodeName();
            if (!"key".equals(nodeName)) continue;
            this.keys.add(new SKey(c));
        }
    }

    public SortComparator comparator(SStyle style, LLocale locale) {
        return new SortComparator(style, locale);
    }

    public class SortComparator
    implements Comparator<CSLItemData> {
        private final SStyle style;
        private final LLocale locale;
        private final AlphanumComparator comparator;
        private int citationNumberDirection = 1;

        public SortComparator(SStyle style, LLocale locale) {
            this.style = style;
            this.locale = locale;
            this.comparator = new AlphanumComparator(locale.getLang());
        }

        public int getCitationNumberDirection() {
            return this.citationNumberDirection;
        }

        @Override
        public int compare(CSLItemData a, CSLItemData b) {
            Integer result = null;
            for (SKey key : SSort.this.keys) {
                RenderContext ctxa = new RenderContext(this.style, this.locale, a);
                CollectingVariableListener vl = new CollectingVariableListener();
                ctxa.addVariableListener(vl);
                key.render(ctxa);
                ctxa.removeVariableListener(vl);
                if (vl.getCalled().contains("citation-number")) {
                    this.citationNumberDirection = key.getSort();
                    if (result != null) break;
                }
                if (result != null) continue;
                RenderContext ctxb = new RenderContext(this.style, this.locale, b);
                key.render(ctxb);
                String sa = ctxa.getResult().toString();
                String sb = ctxb.getResult().toString();
                if (sa.isEmpty() && !sb.isEmpty()) {
                    result = 1;
                    continue;
                }
                if (!sa.isEmpty() && sb.isEmpty()) {
                    result = -1;
                    continue;
                }
                int c = this.comparator.compare(sa, sb);
                if (c == 0) continue;
                result = c * key.getSort();
            }
            return result != null ? result : 0;
        }
    }
}

