/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.format.Format;
import de.undercouch.citeproc.helper.SmartQuotes;
import de.undercouch.citeproc.helper.StringHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseFormat
implements Format {
    private static final Map<String, String> MERGE_PUNCTUATION_MAP;
    protected boolean convertLinks = false;

    protected void postProcess(TokenBuffer buffer, RenderContext ctx) {
        Token t1;
        int i;
        List<Token> tokens = buffer.getTokens();
        SmartQuotes sq = new SmartQuotes(ctx.getTerm("open-inner-quote"), ctx.getTerm("close-inner-quote"), ctx.getTerm("open-quote"), ctx.getTerm("close-quote"), ctx.getLocale().getLang());
        for (i = 0; i < tokens.size(); ++i) {
            Token t = tokens.get(i);
            if (t.getType() != Token.Type.TEXT && t.getType() != Token.Type.PREFIX && t.getType() != Token.Type.SUFFIX && t.getType() != Token.Type.DELIMITER) continue;
            tokens.set(i, new Token.Builder(t).text(sq.apply(t.getText())).build());
        }
        if (ctx.getLocale().getStyleOptions().isPunctuationInQuote()) {
            for (i = 0; i < tokens.size() - 1; ++i) {
                Token t0 = tokens.get(i);
                t1 = tokens.get(i + 1);
                if (t0.getType() != Token.Type.CLOSE_QUOTE || !StringUtils.startsWithAny((CharSequence)t1.getText(), (CharSequence[])new CharSequence[]{",", "."})) continue;
                String nextText = t1.getText();
                String punctuation = nextText.substring(0, 1);
                String rest = nextText.substring(1);
                tokens.add(i, new Token.Builder(t1).text(punctuation).build());
                tokens.set(++i + 1, new Token.Builder(t1).text(rest).build());
            }
        }
        for (i = 1; i < tokens.size(); ++i) {
            int overlap;
            int j = BaseFormat.findPreviousNonQuote(tokens, i);
            if (j < 0 || (t1 = tokens.get(i)).getType() != Token.Type.PREFIX && t1.getType() != Token.Type.SUFFIX && t1.getType() != Token.Type.DELIMITER) continue;
            Token t0 = tokens.get(j);
            String t0str = t0.getText();
            if (t0str.length() < t1.getText().length()) {
                StringBuilder pre = new StringBuilder(t0str);
                while (pre.length() < t1.getText().length() && j > 0) {
                    t0 = tokens.get(--j);
                    pre.insert(0, t0.getText());
                }
                t0str = pre.toString();
            }
            if ((overlap = StringHelper.overlap(t0str, t1.getText())) <= 0) continue;
            String rest = t1.getText().substring(overlap);
            if (rest.isEmpty()) {
                tokens.remove(i);
                --i;
                continue;
            }
            tokens.set(i, new Token.Builder(t1).text(rest).build());
        }
        for (i = 1; i < tokens.size(); ++i) {
            String lookup;
            String replacement;
            int j = BaseFormat.findPreviousNonQuote(tokens, i);
            if (j < 0) continue;
            Token t0 = tokens.get(j);
            Token t12 = tokens.get(i);
            if (t0.getText().isEmpty() || t12.getText().isEmpty() || t12.getType() != Token.Type.PREFIX && t12.getType() != Token.Type.SUFFIX && t12.getType() != Token.Type.DELIMITER || (replacement = MERGE_PUNCTUATION_MAP.get(lookup = t0.getText().substring(t0.getText().length() - 1) + t12.getText().substring(0, 1))) == null) continue;
            String nt0 = t0.getText().substring(0, t0.getText().length() - 1) + replacement;
            tokens.set(j, new Token.Builder(t0).text(nt0).build());
            String rest = t12.getText().substring(1);
            if (rest.isEmpty()) {
                tokens.remove(i);
                --i;
                continue;
            }
            tokens.set(i, new Token.Builder(t12).text(rest).build());
        }
        if (this.convertLinks) {
            for (i = 1; i < tokens.size(); ++i) {
                Token t0 = tokens.get(i - 1);
                t1 = tokens.get(i);
                if (t1.getType() != Token.Type.DOI || t0.getType() != Token.Type.PREFIX || !t0.getText().matches("^https?://doi.org/?$")) continue;
                String url = this.addDOIPrefix(t1.getText());
                if (!url.equals(t1.getText())) {
                    tokens.set(i, new Token.Builder(t1).text(url).build());
                }
                tokens.remove(i - 1);
            }
        }
    }

    private static int findPreviousNonQuote(List<Token> tokens, int i) {
        for (int j = i - 1; j >= 0; --j) {
            Token t = tokens.get(j);
            if (t.getType() == Token.Type.CLOSE_QUOTE) continue;
            return j;
        }
        return -1;
    }

    @Override
    public void setConvertLinks(boolean convert) {
        this.convertLinks = convert;
    }

    @Override
    public String formatCitation(RenderContext ctx) {
        TokenBuffer buffer = new TokenBuffer();
        buffer.append(ctx.getResult());
        this.postProcess(buffer, ctx);
        return this.doFormatCitation(buffer, ctx);
    }

    protected abstract String doFormatCitation(TokenBuffer var1, RenderContext var2);

    @Override
    public String formatBibliographyEntry(RenderContext ctx) {
        TokenBuffer buffer = new TokenBuffer();
        buffer.append(ctx.getResult());
        this.postProcess(buffer, ctx);
        return this.doFormatBibliographyEntry(buffer, ctx);
    }

    protected abstract String doFormatBibliographyEntry(TokenBuffer var1, RenderContext var2);

    protected String formatURL(String str) {
        String escapedStr = this.escape(str);
        return this.doFormatLink(escapedStr, escapedStr);
    }

    protected String addDOIPrefix(String str) {
        if (!str.matches("^https?://.*$")) {
            str = "https://doi.org/" + str;
        }
        return str;
    }

    protected String formatDOI(String str) {
        String uri = this.addDOIPrefix(str);
        return this.doFormatLink(this.escape(str), this.escape(uri));
    }

    protected abstract String doFormatLink(String var1, String var2);

    protected String escape(String str) {
        return str;
    }

    protected String format(TokenBuffer buffer) {
        StringBuilder result = new StringBuilder();
        int cfs = 0;
        int cfv = 0;
        int cfw = 0;
        int ctd = 0;
        int cva = 0;
        for (Token t : buffer.getTokens()) {
            int tokenFormattingAttributes = t.getFormattingAttributes();
            int tfs = FormattingAttributes.getFontStyle(tokenFormattingAttributes);
            int tfv = FormattingAttributes.getFontVariant(tokenFormattingAttributes);
            int tfw = FormattingAttributes.getFontWeight(tokenFormattingAttributes);
            int ttd = FormattingAttributes.getTextDecoration(tokenFormattingAttributes);
            int tva = FormattingAttributes.getVerticalAlign(tokenFormattingAttributes);
            this.compareFormattingAttribute(cfs, tfs, this::closeFontStyle, result);
            this.compareFormattingAttribute(cfv, tfv, this::closeFontVariant, result);
            this.compareFormattingAttribute(cfw, tfw, this::closeFontWeight, result);
            this.compareFormattingAttribute(ctd, ttd, this::closeTextDecoration, result);
            this.compareFormattingAttribute(cva, tva, this::closeVerticalAlign, result);
            this.compareFormattingAttribute(tva, cva, this::openVerticalAlign, result);
            this.compareFormattingAttribute(ttd, ctd, this::openTextDecoration, result);
            this.compareFormattingAttribute(tfw, cfw, this::openFontWeight, result);
            this.compareFormattingAttribute(tfv, cfv, this::openFontVariant, result);
            this.compareFormattingAttribute(tfs, cfs, this::openFontStyle, result);
            cfs = tfs;
            cfv = tfv;
            cfw = tfw;
            ctd = ttd;
            cva = tva;
            if (this.convertLinks && (t.getType() == Token.Type.URL || t.getType() == Token.Type.DOI)) {
                String link = t.getType() == Token.Type.URL ? this.formatURL(t.getText()) : this.formatDOI(t.getText());
                result.append(link);
                continue;
            }
            result.append(this.escape(t.getText()));
        }
        this.compareFormattingAttribute(cfs, 0, this::closeFontStyle, result);
        this.compareFormattingAttribute(cfv, 0, this::closeFontVariant, result);
        this.compareFormattingAttribute(cfw, 0, this::closeFontWeight, result);
        this.compareFormattingAttribute(ctd, 0, this::closeTextDecoration, result);
        this.compareFormattingAttribute(cva, 0, this::closeVerticalAlign, result);
        return result.toString();
    }

    protected void compareFormattingAttribute(int a, int b, Function<Integer, String> f, StringBuilder result) {
        String str;
        if (a != b && a != 0 && (a != 1 || b != 0) && (str = f.apply(a)) != null) {
            result.append(str);
        }
    }

    protected String openFontStyle(int fontStyle) {
        return null;
    }

    protected String closeFontStyle(int fontStyle) {
        return null;
    }

    protected String openFontVariant(int fontVariant) {
        return null;
    }

    protected String closeFontVariant(int fontVariant) {
        return null;
    }

    protected String openFontWeight(int fontWeight) {
        return null;
    }

    protected String closeFontWeight(int fontWeight) {
        return null;
    }

    protected String openTextDecoration(int textDecoration) {
        return null;
    }

    protected String closeTextDecoration(int textDecoration) {
        return null;
    }

    protected String openVerticalAlign(int verticalAlign) {
        return null;
    }

    protected String closeVerticalAlign(int verticalAlign) {
        return null;
    }

    static {
        HashMap<String, String> mpm = new HashMap<String, String>();
        mpm.put("!.", "!");
        mpm.put("!:", "!");
        mpm.put("?.", "?");
        mpm.put("?:", "?");
        mpm.put(":!", "!");
        mpm.put(":?", "?");
        mpm.put(":.", ":");
        mpm.put(";!", "!");
        mpm.put(";?", "?");
        mpm.put(";:", ";");
        mpm.put(";.", ";");
        MERGE_PUNCTUATION_MAP = Collections.unmodifiableMap(mpm);
    }
}

