/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SElement;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.rendering.SNameInheritableAttributes;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public class SName
implements SElement {
    public static final int FORM_LONG = 0;
    public static final int FORM_SHORT = 1;
    public static final int FORM_COUNT = 2;
    private final String variable;
    private final String delimiter;
    private final int form;
    private final int formattingAttributes;
    private final SNameInheritableAttributes inheritableAttributes;

    public SName(Node node, String variable) {
        String form;
        String delimiter;
        this.variable = variable;
        this.inheritableAttributes = new SNameInheritableAttributes(node);
        if (node != null) {
            this.formattingAttributes = FormattingAttributes.of(node);
            delimiter = NodeHelper.getAttrValue(node, "delimiter");
            form = NodeHelper.getAttrValue(node, "form");
        } else {
            this.formattingAttributes = 0;
            delimiter = null;
            form = null;
        }
        if (delimiter == null) {
            delimiter = ", ";
        }
        this.delimiter = delimiter;
        this.form = "count".equals(form) ? 2 : ("short".equals(form) ? 1 : 0);
    }

    public String getVariable() {
        return this.variable;
    }

    public int getForm() {
        return this.form;
    }

    @Override
    public void render(RenderContext ctx) {
        ArrayList<CSLName> names = new ArrayList<CSLName>();
        if (this.variable != null) {
            String[] variables;
            for (String v : variables = this.variable.split("\\s+")) {
                CSLName[] vn = ctx.getNameVariable(v);
                if (vn == null) continue;
                names.addAll(Arrays.asList(vn));
            }
        }
        if (names.isEmpty()) {
            return;
        }
        SNameInheritableAttributes ia = ctx.getInheritedNameAttributes().merge(this.inheritableAttributes);
        String and = ia.getAnd();
        Integer etAlMin = ia.getEtAlMin();
        Integer etAlUseFirst = ia.getEtAlUseFirst();
        String nameAsSortOrder = ia.getNameAsSortOrder();
        String delimiterPrecedesEtAl = ia.getDelimiterPrecedesEtAl();
        String delimiterPrecedesLast = ia.getDelimiterPrecedesLast();
        String initializeWith = ia.getInitializeWith();
        boolean initialize = ia.isInitialize();
        String sortSeparator = ia.getSortSeparator();
        String renderedAnd = "text".equals(and) ? " " + ctx.getTerm("and") + " " : ("symbol".equals(and) ? " & " : this.delimiter);
        int max = -1;
        if (etAlMin != null && etAlUseFirst != null && names.size() >= etAlMin && (max = etAlUseFirst.intValue()) == 0) {
            return;
        }
        if (this.form == 2) {
            int count = names.size();
            if (max > -1 && max < count) {
                count = max;
            }
            ctx.emit(String.valueOf(count), this.formattingAttributes);
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            boolean nameAsSort = "all".equals(nameAsSortOrder) || i == 0 && "first".equals(nameAsSortOrder);
            builder.append(this.render((CSLName)names.get(i), nameAsSort, initializeWith, initialize, sortSeparator));
            if (i >= names.size() - 1) continue;
            if (i == max - 1) {
                String etAl = ctx.getTerm("et-al");
                this.appendDelimiter(builder, delimiterPrecedesEtAl, i, max > 1);
                this.appendAnd(builder, " " + etAl);
                break;
            }
            if (i == names.size() - 2) {
                boolean delimiterAppended = this.appendDelimiter(builder, delimiterPrecedesLast, i, names.size() > 2);
                if (delimiterAppended && renderedAnd.equals(this.delimiter)) continue;
                this.appendAnd(builder, renderedAnd);
                continue;
            }
            builder.append(this.delimiter);
        }
        ctx.emit(builder.toString(), this.formattingAttributes);
    }

    private boolean appendDelimiter(StringBuilder builder, String delimiterPrecedes, int i, boolean contextual) {
        boolean delimiterAppended = false;
        switch (delimiterPrecedes) {
            case "contextual": {
                if (!contextual) break;
                builder.append(this.delimiter);
                delimiterAppended = true;
                break;
            }
            case "always": {
                builder.append(this.delimiter);
                delimiterAppended = true;
                break;
            }
            case "after-inverted-name": {
                if (i != 0) break;
                builder.append(this.delimiter);
                delimiterAppended = true;
                break;
            }
        }
        return delimiterAppended;
    }

    private void appendAnd(StringBuilder builder, String and) {
        if (Character.isWhitespace(builder.charAt(builder.length() - 1)) && Character.isWhitespace(and.charAt(0))) {
            builder.append(and, 1, and.length());
        } else {
            builder.append(and);
        }
    }

    private String render(CSLName name, boolean nameAsSort, String initializeWith, boolean initialize, String sortSeparator) {
        String family = name.getFamily();
        if (family != null) {
            if (name.getNonDroppingParticle() != null) {
                family = name.getNonDroppingParticle().trim() + " " + family;
            }
            if (this.form == 1) {
                return family;
            }
            if (name.getDroppingParticle() != null) {
                family = name.getDroppingParticle().trim() + " " + family;
            }
            if (name.getSuffix() != null) {
                family = StringUtils.stripEnd((String)family, null) + " " + name.getSuffix().trim();
            }
        }
        StringBuilder result = new StringBuilder();
        String given = name.getGiven();
        StringBuilder givenBuffer = new StringBuilder();
        if (given != null) {
            if (initializeWith != null) {
                if (initialize) {
                    boolean found = true;
                    boolean hyphen = false;
                    for (int i = 0; i < given.length(); ++i) {
                        char c = given.charAt(i);
                        if (c == '-') {
                            found = true;
                            hyphen = true;
                            continue;
                        }
                        if (Character.isWhitespace(c) || c == '.') {
                            found = true;
                            continue;
                        }
                        if (!found) continue;
                        if (givenBuffer.length() > 0) {
                            givenBuffer.append(hyphen ? (char)'-' : ' ');
                        }
                        givenBuffer.append(c).append(initializeWith);
                        found = false;
                        hyphen = false;
                    }
                } else {
                    StringBuilder tmp = new StringBuilder();
                    for (int i = 0; i < given.length(); ++i) {
                        char c = given.charAt(i);
                        tmp.append(c);
                        if (!Character.isWhitespace(c) && c != '-' && c != '.') continue;
                        givenBuffer.append((CharSequence)tmp);
                        if (tmp.length() == 1) {
                            givenBuffer.append(initializeWith);
                        }
                        tmp = new StringBuilder();
                    }
                    if (tmp.length() > 0) {
                        givenBuffer.append((CharSequence)tmp);
                        if (tmp.length() == 1) {
                            givenBuffer.append(initializeWith);
                        }
                    }
                }
            } else {
                givenBuffer.append(given);
            }
        }
        if (nameAsSort) {
            if (family != null) {
                result.append(family);
            }
            if (family != null && given != null) {
                result.append(sortSeparator);
            }
            if (given != null) {
                result.append((CharSequence)givenBuffer);
            }
        } else {
            if (given != null) {
                result.append((CharSequence)givenBuffer);
            }
            if (given != null && family != null) {
                result.append(" ");
            }
            if (family != null) {
                result.append(family);
            }
        }
        return result.toString();
    }
}

