/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SElement;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.rendering.SLabel;
import de.undercouch.citeproc.csl.internal.rendering.SName;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.csl.internal.rendering.SSubstitute;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SNames
implements SRenderingElement {
    private final String variableAttribute;
    private final Affixes affixes;
    private final int formattingAttributes;
    private final SSubstitute substitute;
    private final List<SElement> elements = new ArrayList<SElement>();

    public SNames(Node node) {
        this(node, NodeHelper.getAttrValue(node, "variable"), true);
    }

    public SNames(Node node, String variableAttribute, boolean parseSubstitute) {
        Node substituteNode;
        String[] variables = variableAttribute == null ? new String[]{} : variableAttribute.split("\\s+");
        String delimiter = NodeHelper.getAttrValue(node, "delimiter");
        this.formattingAttributes = FormattingAttributes.of(node);
        boolean allFormCount = true;
        Node firstNameNode = null;
        for (String variable : variables) {
            if (!this.elements.isEmpty() && delimiter != null) {
                this.elements.add(ctx -> {
                    if (!ctx.getResult().isEmpty()) {
                        ctx.emit(delimiter);
                    }
                });
            }
            ArrayList<SElement> elementsForVariable = new ArrayList<SElement>();
            SName name = null;
            Node nameNode = null;
            SLabel label = null;
            int namePos = -1;
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node c = children.item(i);
                String nodeName = c.getNodeName();
                if ("name".equals(nodeName)) {
                    name = new SName(c, variable);
                    nameNode = c;
                    if (namePos >= 0) {
                        elementsForVariable.set(namePos, name);
                        continue;
                    }
                    namePos = elementsForVariable.size();
                    elementsForVariable.add(name);
                    continue;
                }
                if (label != null || !"label".equals(nodeName)) continue;
                label = new SLabel(c, variable);
                elementsForVariable.add(label);
            }
            if (name == null) {
                name = new SName(null, variable);
                elementsForVariable.add(0, name);
            }
            if (firstNameNode == null) {
                firstNameNode = nameNode;
            }
            allFormCount = allFormCount && name.getForm() == 2;
            this.elements.addAll(elementsForVariable);
        }
        this.variableAttribute = variableAttribute;
        this.substitute = parseSubstitute ? ((substituteNode = NodeHelper.findDirectChild(node, "substitute")) != null ? new SSubstitute(substituteNode, node) : null) : null;
        if (allFormCount) {
            this.elements.clear();
            this.elements.add(new SName(firstNameNode, variableAttribute));
            this.affixes = new Affixes();
        } else {
            this.affixes = new Affixes(node);
        }
    }

    public String getVariableAttribute() {
        return this.variableAttribute;
    }

    @Override
    public void render(RenderContext ctx) {
        RenderContext tmp = new RenderContext(ctx);
        this.affixes.wrap(this::renderInternal).accept(tmp);
        if (tmp.getResult().isEmpty() && this.substitute != null) {
            this.substitute.render(tmp);
        }
        ctx.emit(tmp.getResult());
    }

    private void renderInternal(RenderContext ctx) {
        RenderContext child = new RenderContext(ctx);
        for (SElement e : this.elements) {
            e.render(child);
        }
        ctx.emit(child.getResult(), this.formattingAttributes);
    }
}

