/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberHelper {
    private static final String NUMBER = "([a-zA-Z]*[0-9]+[a-zA-Z]*)";
    private static final String SEPARATOR = "([,\\-&])";
    private static final String NUMERIC_REGEX = "^\\s*([a-zA-Z]*[0-9]+[a-zA-Z]*)(\\s*([,\\-&])\\s*([a-zA-Z]*[0-9]+[a-zA-Z]*))*\\s*$";
    private static final String EXTRACT_REGEX = "([a-zA-Z]*[0-9]+[a-zA-Z]*)|([,\\-&])";
    private static final Pattern numericRegex = Pattern.compile("^\\s*([a-zA-Z]*[0-9]+[a-zA-Z]*)(\\s*([,\\-&])\\s*([a-zA-Z]*[0-9]+[a-zA-Z]*))*\\s*$");
    private static final Pattern extractRegex = Pattern.compile("([a-zA-Z]*[0-9]+[a-zA-Z]*)|([,\\-&])");

    public static boolean isNumeric(String str) {
        return numericRegex.matcher(str).matches();
    }

    public static List<NumberToken> tokenize(String str) {
        ArrayList<NumberToken> result = new ArrayList<NumberToken>();
        Matcher matcher = extractRegex.matcher(str);
        while (matcher.find()) {
            String g1 = matcher.group(1);
            String g2 = matcher.group(2);
            if (g1 != null) {
                result.add(new NumberToken(g1, NumberTokenType.NUMBER));
                continue;
            }
            if (g2 == null) continue;
            result.add(new NumberToken(g2, NumberTokenType.SEPARATOR));
        }
        return result;
    }

    public static enum NumberTokenType {
        NUMBER,
        SEPARATOR;

    }

    public static class NumberToken {
        private final String token;
        private final NumberTokenType type;

        public NumberToken(String token, NumberTokenType type) {
            this.token = token;
            this.type = type;
        }

        public String getToken() {
            return this.token;
        }

        public NumberTokenType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberToken that = (NumberToken)o;
            return this.token.equals(that.token) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.token, this.type});
        }

        public String toString() {
            return this.token + "[" + (Object)((Object)this.type) + "]";
        }
    }
}

