/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.CSLCitation;
import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLCitationItemBuilder;
import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.internal.GeneratedCitation;
import de.undercouch.citeproc.csl.internal.SMacro;
import de.undercouch.citeproc.csl.internal.SStyle;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.VariableForm;
import de.undercouch.citeproc.csl.internal.VariableListener;
import de.undercouch.citeproc.csl.internal.locale.LLocale;
import de.undercouch.citeproc.csl.internal.locale.LTerm;
import de.undercouch.citeproc.csl.internal.rendering.SLabel;
import de.undercouch.citeproc.csl.internal.rendering.SNameInheritableAttributes;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class RenderContext {
    private final SStyle style;
    private final LLocale locale;
    private final CSLItemData itemData;
    private final CSLCitation citation;
    private final List<GeneratedCitation> generatedCitations;
    private final CSLCitationItem citationItem;
    private final TokenBuffer result = new TokenBuffer();
    private final Set<VariableListener> variableListeners;
    private final Set<String> suppressedVariables;
    private final AtomicReference<SLabel> lastLabelRendered;
    private final SNameInheritableAttributes inheritedNameAttributes;

    public RenderContext(SStyle style, LLocale locale, CSLItemData itemData) {
        this(style, locale, itemData, null, null);
    }

    public RenderContext(SStyle style, LLocale locale, CSLItemData itemData, CSLCitation citation, List<GeneratedCitation> generatedCitations) {
        this.style = style;
        this.locale = locale;
        this.itemData = itemData;
        this.citation = citation;
        this.generatedCitations = generatedCitations;
        this.citationItem = itemData != null ? new CSLCitationItemBuilder(itemData.getId()).itemData(itemData).build() : null;
        this.variableListeners = new LinkedHashSet<VariableListener>();
        this.suppressedVariables = new HashSet<String>();
        this.lastLabelRendered = new AtomicReference();
        this.inheritedNameAttributes = style.getInheritableNameAttributes();
    }

    public RenderContext(RenderContext parent) {
        this(parent, parent.itemData, parent.citation, parent.generatedCitations, parent.citationItem, parent.inheritedNameAttributes);
    }

    public RenderContext(RenderContext parent, SNameInheritableAttributes inheritedNameAttributes) {
        this(parent, parent.itemData, parent.citation, parent.generatedCitations, parent.citationItem, inheritedNameAttributes);
    }

    public RenderContext(RenderContext parent, CSLCitationItem citationItem) {
        this(parent, citationItem.getItemData(), parent.getCitation(), parent.getGeneratedCitations(), citationItem, parent.inheritedNameAttributes);
    }

    private RenderContext(RenderContext parent, CSLItemData itemData, CSLCitation citation, List<GeneratedCitation> generatedCitations, CSLCitationItem citationItem, SNameInheritableAttributes inheritedNameAttributes) {
        this.style = parent.style;
        this.locale = parent.locale;
        this.itemData = itemData;
        this.citation = citation;
        this.generatedCitations = generatedCitations;
        this.citationItem = citationItem;
        this.variableListeners = parent.variableListeners;
        this.suppressedVariables = parent.suppressedVariables;
        this.lastLabelRendered = parent.lastLabelRendered;
        this.inheritedNameAttributes = inheritedNameAttributes;
    }

    public SStyle getStyle() {
        return this.style;
    }

    public LLocale getLocale() {
        return this.locale;
    }

    public Locale getItemLocale() {
        if (this.itemData != null && this.itemData.getLanguage() != null) {
            return Locale.forLanguageTag(this.itemData.getLanguage());
        }
        return this.getLocale().getLang();
    }

    public SMacro getMacro(String name) {
        SMacro result = this.style.getMacros().get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown macro: " + name);
        }
        return result;
    }

    public Object getVariable(String name) {
        return this.getVariable(name, false);
    }

    public Object getVariable(String name, boolean ignoreListeners) {
        Object result = this.getStringVariable(name, ignoreListeners);
        if (result != null) {
            return result;
        }
        result = this.getDateVariable(name, ignoreListeners);
        if (result != null) {
            return result;
        }
        return this.getNameVariable(name, ignoreListeners);
    }

    public String getStringVariable(String name) {
        return this.getStringVariable(name, false);
    }

    public String getStringVariable(String name, boolean ignoreListeners) {
        return this.getStringVariable(name, VariableForm.LONG, ignoreListeners);
    }

    public String getStringVariable(String name, VariableForm form) {
        return this.getStringVariable(name, form, false);
    }

    public String getStringVariable(String name, VariableForm form, boolean ignoreListeners) {
        String result = null;
        if (!this.suppressedVariables.contains(name)) {
            switch (name) {
                case "abstract": {
                    result = this.itemData.getAbstrct();
                    break;
                }
                case "annote": {
                    result = this.itemData.getAnnote();
                    break;
                }
                case "archive": {
                    result = this.itemData.getArchive();
                    break;
                }
                case "archive_location": {
                    result = this.itemData.getArchiveLocation();
                    break;
                }
                case "archive-place": {
                    result = this.itemData.getArchivePlace();
                    break;
                }
                case "authority": {
                    result = this.itemData.getAuthority();
                    break;
                }
                case "call-number": {
                    result = this.itemData.getCallNumber();
                    break;
                }
                case "chapter-number": {
                    result = this.itemData.getChapterNumber();
                    break;
                }
                case "citation-label": {
                    result = this.itemData.getCitationLabel();
                    break;
                }
                case "citation-number": {
                    result = this.itemData.getCitationNumber();
                    break;
                }
                case "collection-number": {
                    result = this.itemData.getCollectionNumber();
                    break;
                }
                case "collection-title": {
                    if (form == VariableForm.SHORT) {
                        result = this.itemData.getCollectionTitleShort();
                    }
                    if (result != null) break;
                    result = this.itemData.getCollectionTitle();
                    break;
                }
                case "collection-title-short": {
                    result = this.itemData.getCollectionTitleShort();
                    break;
                }
                case "container-title": {
                    if (form == VariableForm.SHORT) {
                        result = this.itemData.getContainerTitleShort();
                    }
                    if (result != null) break;
                    result = this.itemData.getContainerTitle();
                    break;
                }
                case "container-title-short": {
                    result = this.itemData.getContainerTitleShort();
                    break;
                }
                case "dimensions": {
                    result = this.itemData.getDimensions();
                    break;
                }
                case "DOI": {
                    result = this.itemData.getDOI();
                    break;
                }
                case "edition": {
                    result = this.itemData.getEdition();
                    break;
                }
                case "event": {
                    result = this.itemData.getEvent();
                    break;
                }
                case "event-place": {
                    result = this.itemData.getEventPlace();
                    break;
                }
                case "first-reference-note-number": {
                    result = this.itemData.getFirstReferenceNoteNumber();
                    break;
                }
                case "genre": {
                    result = this.itemData.getGenre();
                    break;
                }
                case "ISBN": {
                    result = this.itemData.getISBN();
                    break;
                }
                case "ISSN": {
                    result = this.itemData.getISSN();
                    break;
                }
                case "issue": {
                    result = this.itemData.getIssue();
                    break;
                }
                case "jurisdiction": {
                    result = this.itemData.getJurisdiction();
                    break;
                }
                case "keyword": {
                    result = this.itemData.getKeyword();
                    break;
                }
                case "locator": {
                    result = this.itemData.getLocator();
                    break;
                }
                case "medium": {
                    result = this.itemData.getMedium();
                    break;
                }
                case "note": {
                    result = this.itemData.getNote();
                    break;
                }
                case "number": {
                    result = this.itemData.getNumber();
                    break;
                }
                case "number-of-pages": {
                    result = this.itemData.getNumberOfPages();
                    break;
                }
                case "number-of-volumes": {
                    result = this.itemData.getNumberOfVolumes();
                    break;
                }
                case "original-publisher": {
                    result = this.itemData.getOriginalPublisher();
                    break;
                }
                case "original-publisher-place": {
                    result = this.itemData.getOriginalPublisherPlace();
                    break;
                }
                case "original-title": {
                    result = this.itemData.getOriginalTitle();
                    break;
                }
                case "page": {
                    result = this.itemData.getPage();
                    break;
                }
                case "page-first": {
                    result = this.itemData.getPageFirst();
                    break;
                }
                case "PMCID": {
                    result = this.itemData.getPMCID();
                    break;
                }
                case "PMID": {
                    result = this.itemData.getPMID();
                    break;
                }
                case "publisher": {
                    result = this.itemData.getPublisher();
                    break;
                }
                case "publisher-place": {
                    result = this.itemData.getPublisherPlace();
                    break;
                }
                case "references": {
                    result = this.itemData.getReferences();
                    break;
                }
                case "reviewed-title": {
                    result = this.itemData.getReviewedTitle();
                    break;
                }
                case "scale": {
                    result = this.itemData.getScale();
                    break;
                }
                case "section": {
                    result = this.itemData.getSection();
                    break;
                }
                case "source": {
                    result = this.itemData.getSource();
                    break;
                }
                case "status": {
                    result = this.itemData.getStatus();
                    break;
                }
                case "title": {
                    if (form == VariableForm.SHORT) {
                        result = this.itemData.getTitleShort();
                    }
                    if (result != null) break;
                    result = this.itemData.getTitle();
                    break;
                }
                case "title-short": {
                    result = this.itemData.getTitleShort();
                    break;
                }
                case "URL": {
                    result = this.itemData.getURL();
                    break;
                }
                case "version": {
                    result = this.itemData.getVersion();
                    break;
                }
                case "volume": {
                    result = this.itemData.getVolume();
                    break;
                }
                case "year-suffix": {
                    result = this.itemData.getYearSuffix();
                    break;
                }
            }
        }
        if (!ignoreListeners) {
            for (VariableListener l : this.variableListeners) {
                l.onFetchStringVariable(name, result);
            }
        }
        return result;
    }

    public CSLDate getDateVariable(String name) {
        return this.getDateVariable(name, false);
    }

    public CSLDate getDateVariable(String name, boolean ignoreListeners) {
        CSLDate result;
        if (!this.suppressedVariables.contains(name)) {
            switch (name) {
                case "accessed": {
                    result = this.itemData.getAccessed();
                    break;
                }
                case "container": {
                    result = this.itemData.getContainer();
                    break;
                }
                case "event-date": {
                    result = this.itemData.getEventDate();
                    break;
                }
                case "issued": {
                    result = this.itemData.getIssued();
                    break;
                }
                case "original-date": {
                    result = this.itemData.getOriginalDate();
                    break;
                }
                case "submitted": {
                    result = this.itemData.getSubmitted();
                    break;
                }
                default: {
                    result = null;
                    break;
                }
            }
        } else {
            result = null;
        }
        if (!ignoreListeners) {
            for (VariableListener l : this.variableListeners) {
                l.onFetchDateVariable(name, result);
            }
        }
        return result;
    }

    public CSLName[] getNameVariable(String name) {
        return this.getNameVariable(name, false);
    }

    public CSLName[] getNameVariable(String name, boolean ignoreListeners) {
        CSLName[] result;
        if (!this.suppressedVariables.contains(name)) {
            switch (name) {
                case "author": {
                    result = this.itemData.getAuthor();
                    break;
                }
                case "collection-editor": {
                    result = this.itemData.getCollectionEditor();
                    break;
                }
                case "composer": {
                    result = this.itemData.getComposer();
                    break;
                }
                case "container-author": {
                    result = this.itemData.getContainerAuthor();
                    break;
                }
                case "director": {
                    result = this.itemData.getDirector();
                    break;
                }
                case "editor": {
                    result = this.itemData.getEditor();
                    break;
                }
                case "editorial-director": {
                    result = this.itemData.getEditorialDirector();
                    break;
                }
                case "illustrator": {
                    result = this.itemData.getIllustrator();
                    break;
                }
                case "interviewer": {
                    result = this.itemData.getInterviewer();
                    break;
                }
                case "original-author": {
                    result = this.itemData.getOriginalAuthor();
                    break;
                }
                case "recipient": {
                    result = this.itemData.getRecipient();
                    break;
                }
                case "reviewed-author": {
                    result = this.itemData.getReviewedAuthor();
                    break;
                }
                case "translator": {
                    result = this.itemData.getTranslator();
                    break;
                }
                default: {
                    result = null;
                    break;
                }
            }
        } else {
            result = null;
        }
        if (!ignoreListeners) {
            for (VariableListener l : this.variableListeners) {
                l.onFetchNameVariable(name, result);
            }
        }
        return result;
    }

    public void suppressVariable(String name) {
        this.suppressedVariables.add(name);
    }

    public String getTerm(String name) {
        return this.getTerm(name, LTerm.Form.LONG);
    }

    public String getTerm(String name, boolean plural) {
        return this.getTerm(name, LTerm.Form.LONG, plural);
    }

    public String getTerm(String name, LTerm.Form form) {
        return this.getTerm(name, form, false);
    }

    public String getTerm(String name, LTerm.Form form, boolean plural) {
        Map<String, LTerm> tm = this.locale.getTerms().get((Object)form);
        if (tm == null) {
            throw new IllegalStateException("Unknown term form: " + (Object)((Object)form));
        }
        LTerm t = tm.get(name);
        if (t == null) {
            return null;
        }
        if (plural) {
            return t.getMultiple();
        }
        return t.getSingle();
    }

    public CSLItemData getItemData() {
        return this.itemData;
    }

    public CSLCitation getCitation() {
        return this.citation;
    }

    public List<GeneratedCitation> getGeneratedCitations() {
        return this.generatedCitations;
    }

    public CSLCitationItem getCitationItem() {
        return this.citationItem;
    }

    public void addVariableListener(VariableListener listener) {
        this.variableListeners.add(listener);
    }

    public void removeVariableListener(VariableListener listener) {
        this.variableListeners.remove(listener);
    }

    public Set<VariableListener> getVariableListeners() {
        return this.variableListeners;
    }

    public void setLastLabelRendered(SLabel label) {
        this.lastLabelRendered.set(label);
    }

    public SLabel getLastLabelRendered() {
        return this.lastLabelRendered.get();
    }

    public SNameInheritableAttributes getInheritedNameAttributes() {
        return this.inheritedNameAttributes;
    }

    public RenderContext emit(String text) {
        return this.emit(text, Token.Type.TEXT);
    }

    public RenderContext emit(String text, int formattingAttributes) {
        return this.emit(text, Token.Type.TEXT, formattingAttributes);
    }

    public RenderContext emit(String text, Token.Type type) {
        if (text != null) {
            this.result.append(text, type);
        }
        return this;
    }

    public RenderContext emit(String text, Token.Type type, int formattingAttributes) {
        if (text != null) {
            this.result.append(text, type, formattingAttributes);
        }
        return this;
    }

    public RenderContext emit(Token token) {
        this.result.append(token);
        return this;
    }

    public RenderContext emit(TokenBuffer buffer) {
        this.result.append(buffer);
        return this;
    }

    public RenderContext emit(TokenBuffer buffer, int formattingAttributes) {
        if (formattingAttributes == 0) {
            this.result.append(buffer);
        } else {
            buffer.getTokens().stream().map(t -> new Token.Builder((Token)t).mergeFormattingAttributes(formattingAttributes).build()).forEach(this.result::append);
        }
        return this;
    }

    public TokenBuffer getResult() {
        return this.result;
    }

    public void reset() {
        this.suppressedVariables.clear();
        this.variableListeners.clear();
        this.lastLabelRendered.set(null);
    }
}

