/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SElement;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.StripPeriods;
import de.undercouch.citeproc.csl.internal.locale.LTerm;
import de.undercouch.citeproc.helper.NodeHelper;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public class SDatePart
implements SElement {
    private int[] date;
    private final String name;
    private final String form;
    private final Affixes affixes;
    private final StripPeriods stripPeriods;

    public SDatePart(Node node) {
        this.name = NodeHelper.getAttrValue(node, "name");
        if (this.name == null) {
            throw new IllegalStateException("Missing date part name");
        }
        if (!(this.name.equals("year") || this.name.equals("month") || this.name.equals("day"))) {
            throw new IllegalStateException("Unknown date part name: " + this.name);
        }
        this.form = NodeHelper.getAttrValue(node, "form");
        this.affixes = new Affixes(node);
        this.stripPeriods = new StripPeriods(node);
    }

    public SDatePart(String name, String form) {
        this.name = name;
        this.form = form;
        this.affixes = new Affixes();
        this.stripPeriods = new StripPeriods();
    }

    @Override
    public void render(RenderContext ctx) {
        this.affixes.wrap(this.stripPeriods.wrap(this::renderInternal)).accept(ctx);
    }

    private void renderInternal(RenderContext ctx) {
        String value = null;
        switch (this.name) {
            case "year": {
                if (this.date.length <= 0) break;
                value = this.renderYear(this.date[0]);
                break;
            }
            case "month": {
                if (this.date.length <= 1) break;
                value = this.renderMonth(this.date[1], ctx);
                break;
            }
            case "day": {
                if (this.date.length <= 2) break;
                value = this.renderDay(this.date[2]);
            }
        }
        if (value != null) {
            ctx.emit(value);
        }
    }

    private String renderYear(int year) {
        return String.valueOf(year);
    }

    private String renderMonth(int month, RenderContext ctx) {
        String p = StringUtils.leftPad((String)String.valueOf(month), (int)2, (char)'0');
        String value = "short".equals(this.form) ? ctx.getTerm("month-" + p, LTerm.Form.SHORT) : ("numeric".equals(this.form) ? String.valueOf(month) : ("numeric-leading-zeros".equals(this.form) ? p : ctx.getTerm("month-" + p)));
        return value;
    }

    private String renderDay(int day) {
        String value = String.valueOf(day);
        if ("numeric-leading-zeros".equals(this.form)) {
            value = StringUtils.leftPad((String)value, (int)2, (char)'0');
        }
        return value;
    }

    public String getName() {
        return this.name;
    }

    public void setDate(int[] date) {
        this.date = date;
    }
}

