/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SMacro;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.VariableForm;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.behavior.Quotes;
import de.undercouch.citeproc.csl.internal.behavior.TextCase;
import de.undercouch.citeproc.csl.internal.helper.NumberElement;
import de.undercouch.citeproc.csl.internal.helper.NumberParser;
import de.undercouch.citeproc.csl.internal.locale.LTerm;
import de.undercouch.citeproc.csl.internal.rendering.SLabel;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.List;
import org.w3c.dom.Node;

public class SText
implements SRenderingElement {
    private final String variable;
    private final String macro;
    private final String term;
    private final String form;
    private final String value;
    private final Affixes affixes;
    private final Quotes quotes;
    private final TextCase textCase;
    private final int formattingAttributes;

    public SText(Node node) {
        this.variable = NodeHelper.getAttrValue(node, "variable");
        this.macro = NodeHelper.getAttrValue(node, "macro");
        this.term = NodeHelper.getAttrValue(node, "term");
        this.value = NodeHelper.getAttrValue(node, "value");
        this.affixes = new Affixes(node);
        this.quotes = new Quotes(node);
        this.textCase = new TextCase(node);
        this.formattingAttributes = FormattingAttributes.of(node);
        String form = NodeHelper.getAttrValue(node, "form");
        if (form == null) {
            form = "long";
        }
        this.form = form;
    }

    @Override
    public void render(RenderContext ctx) {
        this.affixes.wrap(this.quotes.wrap(this.textCase.wrap(this::renderInternal))).accept(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderInternal(RenderContext ctx) {
        if (this.variable != null && !this.variable.isEmpty()) {
            boolean ignoreListeners = this.variable.equals("year-suffix");
            String v = ctx.getStringVariable(this.variable, VariableForm.fromString(this.form), ignoreListeners);
            if (v == null) return;
            switch (this.variable) {
                case "page": {
                    String delimiter = ctx.getTerm("page-range-delimiter");
                    ctx.emit(v.replace("-", delimiter), Token.Type.TEXT, this.formattingAttributes);
                    return;
                }
                case "locator": 
                case "number": {
                    List<NumberElement> elements = NumberParser.parse(v);
                    for (int i = 0; i < elements.size(); ++i) {
                        NumberElement e = elements.get(i);
                        SLabel lastLabel = ctx.getLastLabelRendered();
                        if (i > 0 && lastLabel != null && e.getLabel() != null) {
                            lastLabel.render(ctx, i);
                        }
                        ctx.emit(e.getText(), Token.Type.TEXT, this.formattingAttributes);
                    }
                    return;
                }
                case "DOI": {
                    ctx.emit(v, Token.Type.DOI, this.formattingAttributes);
                    return;
                }
                case "URL": {
                    ctx.emit(v, Token.Type.URL, this.formattingAttributes);
                    return;
                }
                default: {
                    ctx.emit(v, Token.Type.TEXT, this.formattingAttributes);
                }
            }
            return;
        }
        if (this.macro != null && !this.macro.isEmpty()) {
            SMacro sm = ctx.getMacro(this.macro);
            if (this.formattingAttributes == 0) {
                sm.render(ctx);
                return;
            } else {
                RenderContext tmp = new RenderContext(ctx);
                sm.render(tmp);
                ctx.emit(tmp.getResult(), this.formattingAttributes);
            }
            return;
        } else if (this.term != null && !this.term.isEmpty()) {
            ctx.emit(ctx.getTerm(this.term, LTerm.Form.fromString(this.form)), this.formattingAttributes);
            return;
        } else {
            if (this.value == null) return;
            ctx.emit(this.value, this.formattingAttributes);
        }
    }
}

