/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeHelper {
    public static String getAttrValue(Node node, String attrName) {
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null");
        }
        if (attrName == null) {
            throw new IllegalArgumentException("Attribute name must not be null");
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attrNode = attributes.getNamedItem(attrName);
        if (attrNode == null) {
            return null;
        }
        return attrNode.getTextContent();
    }

    public static Node findDirectChild(Node node, String name) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!name.equals(c.getNodeName())) continue;
            return c;
        }
        return null;
    }
}

