package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLName}
 * 
 * @author Michel Kraemer
 */
public class CSLNameBuilder {

    private String family;
    private String given;
    private String droppingParticle;
    private String nonDroppingParticle;
    private String suffix;
    private Boolean commaPrefix;
    private Boolean commaSuffix;
    private Boolean staticOrdering;
    private Boolean staticParticles;
    private String literal;
    private Boolean parseNames;
    private Boolean isInstitution;

    public CSLNameBuilder() {

        this.family = null;
        this.given = null;
        this.droppingParticle = null;
        this.nonDroppingParticle = null;
        this.suffix = null;
        this.commaPrefix = null;
        this.commaSuffix = null;
        this.staticOrdering = null;
        this.staticParticles = null;
        this.literal = null;
        this.parseNames = null;
        this.isInstitution = null;

    }

    public CSLNameBuilder family(String family) {
        this.family = family;
        return this;
    }

    public CSLNameBuilder given(String given) {
        this.given = given;
        return this;
    }

    public CSLNameBuilder droppingParticle(String droppingParticle) {
        this.droppingParticle = droppingParticle;
        return this;
    }

    public CSLNameBuilder nonDroppingParticle(String nonDroppingParticle) {
        this.nonDroppingParticle = nonDroppingParticle;
        return this;
    }

    public CSLNameBuilder suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public CSLNameBuilder commaPrefix(Boolean commaPrefix) {
        this.commaPrefix = commaPrefix;
        return this;
    }

    public CSLNameBuilder commaSuffix(Boolean commaSuffix) {
        this.commaSuffix = commaSuffix;
        return this;
    }

    public CSLNameBuilder staticOrdering(Boolean staticOrdering) {
        this.staticOrdering = staticOrdering;
        return this;
    }

    public CSLNameBuilder staticParticles(Boolean staticParticles) {
        this.staticParticles = staticParticles;
        return this;
    }

    public CSLNameBuilder literal(String literal) {
        this.literal = literal;
        return this;
    }

    public CSLNameBuilder parseNames(Boolean parseNames) {
        this.parseNames = parseNames;
        return this;
    }

    public CSLNameBuilder isInstitution(Boolean isInstitution) {
        this.isInstitution = isInstitution;
        return this;
    }

    /**
     * Creates a builder that copies properties from the given original object
     * 
     * @param original
     *            the original object
     */
    public CSLNameBuilder(CSLName original) {

        this.family = original.getFamily();
        this.given = original.getGiven();
        this.droppingParticle = original.getDroppingParticle();
        this.nonDroppingParticle = original.getNonDroppingParticle();
        this.suffix = original.getSuffix();
        this.commaPrefix = original.getCommaPrefix();
        this.commaSuffix = original.getCommaSuffix();
        this.staticOrdering = original.getStaticOrdering();
        this.staticParticles = original.getStaticParticles();
        this.literal = original.getLiteral();
        this.parseNames = original.getParseNames();
        this.isInstitution = original.getIsInstitution();
    }

    public CSLName build() {
        return new CSLName(family, given, droppingParticle, nonDroppingParticle, suffix, commaPrefix, commaSuffix,
                staticOrdering, staticParticles, literal, parseNames, isInstitution);
    }

}
