package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLProperties}
 * 
 * @author Michel Kraemer
 */
public class CSLPropertiesBuilder {

    private Integer noteIndex;
    private Boolean unsorted;

    public CSLPropertiesBuilder() {

        this.noteIndex = 0;
        this.unsorted = null;

    }

    public CSLPropertiesBuilder noteIndex(Integer noteIndex) {
        this.noteIndex = noteIndex;
        return this;
    }

    public CSLPropertiesBuilder unsorted(Boolean unsorted) {
        this.unsorted = unsorted;
        return this;
    }

    /**
     * Creates a builder that copies properties from the given original object
     * 
     * @param original
     *            the original object
     */
    public CSLPropertiesBuilder(CSLProperties original) {

        this.noteIndex = original.getNoteIndex();
        this.unsorted = original.getUnsorted();
    }

    public CSLProperties build() {
        return new CSLProperties(noteIndex, unsorted);
    }

}
