package de.undercouch.citeproc.endnote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A container for EndNote references
 * 
 * @author Michel Kraemer
 */
public class EndNoteLibrary {
    private final List<EndNoteReference> references = new ArrayList<>();

    /**
     * Adds a reference to this library
     * 
     * @param reference
     *            the reference to add
     */
    public void addReference(EndNoteReference reference) {
        references.add(reference);
    }

    /**
     * @return an unmodifiable list of references in this library
     */
    public List<EndNoteReference> getReferences() {
        return Collections.unmodifiableList(references);
    }
}
