package de.undercouch.citeproc.endnote;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

/**
 * An EndNote reference
 * 
 * @author Michel Kraemer
 */
public class EndNoteReference {

    private final String[] authors;
    private final String bookOrConference;
    private final String place;
    private final String year;
    private final String[] editors;
    private final String label;
    private final String language;
    private final String[] translatedAuthors;
    private final String publisher;
    private final String journal;
    private final String[] keywords;
    private final String callNumber;
    private final String accessionNumber;
    private final String numberOrIssue;
    private final String pages;
    private final String translatedTitle;
    private final String electronicResourceNumber;
    private final String tertiaryTitle;
    private final String title;
    private final String URL;
    private final String volume;
    private final String databaseProvider;
    private final String abstrct;
    private final String[] tertiaryAuthors;
    private final String[] notes;
    private final EndNoteType type;
    private final String custom1;
    private final String custom2;
    private final String custom3;
    private final String custom4;
    private final String numberOfVolumes;
    private final String edition;
    private final String date;
    private final String typeOfWork;
    private final String[] subsidiaryAuthors;
    private final String isbnOrIssn;
    private final String shortTitle;
    private final String custom5;
    private final String custom6;
    private final String custom7;
    private final String section;
    private final String originalPublication;
    private final String reprintEdition;
    private final String reviewedItem;
    private final String authorAddress;
    private final String caption;
    private final String linkToPDF;
    private final String researchNotes;
    private final String accessDate;
    private final String lastModifiedDate;
    private final String nameOfDatabase;

    public EndNoteReference() {

        this.authors = null;
        this.bookOrConference = null;
        this.place = null;
        this.year = null;
        this.editors = null;
        this.label = null;
        this.language = null;
        this.translatedAuthors = null;
        this.publisher = null;
        this.journal = null;
        this.keywords = null;
        this.callNumber = null;
        this.accessionNumber = null;
        this.numberOrIssue = null;
        this.pages = null;
        this.translatedTitle = null;
        this.electronicResourceNumber = null;
        this.tertiaryTitle = null;
        this.title = null;
        this.URL = null;
        this.volume = null;
        this.databaseProvider = null;
        this.abstrct = null;
        this.tertiaryAuthors = null;
        this.notes = null;
        this.type = null;
        this.custom1 = null;
        this.custom2 = null;
        this.custom3 = null;
        this.custom4 = null;
        this.numberOfVolumes = null;
        this.edition = null;
        this.date = null;
        this.typeOfWork = null;
        this.subsidiaryAuthors = null;
        this.isbnOrIssn = null;
        this.shortTitle = null;
        this.custom5 = null;
        this.custom6 = null;
        this.custom7 = null;
        this.section = null;
        this.originalPublication = null;
        this.reprintEdition = null;
        this.reviewedItem = null;
        this.authorAddress = null;
        this.caption = null;
        this.linkToPDF = null;
        this.researchNotes = null;
        this.accessDate = null;
        this.lastModifiedDate = null;
        this.nameOfDatabase = null;

    }

    public EndNoteReference(String[] authors, String bookOrConference, String place, String year, String[] editors,
            String label, String language, String[] translatedAuthors, String publisher, String journal,
            String[] keywords, String callNumber, String accessionNumber, String numberOrIssue, String pages,
            String translatedTitle, String electronicResourceNumber, String tertiaryTitle, String title, String URL,
            String volume, String databaseProvider, String abstrct, String[] tertiaryAuthors, String[] notes,
            EndNoteType type, String custom1, String custom2, String custom3, String custom4, String numberOfVolumes,
            String edition, String date, String typeOfWork, String[] subsidiaryAuthors, String isbnOrIssn,
            String shortTitle, String custom5, String custom6, String custom7, String section,
            String originalPublication, String reprintEdition, String reviewedItem, String authorAddress,
            String caption, String linkToPDF, String researchNotes, String accessDate, String lastModifiedDate,
            String nameOfDatabase) {

        this.authors = authors;
        this.bookOrConference = bookOrConference;
        this.place = place;
        this.year = year;
        this.editors = editors;
        this.label = label;
        this.language = language;
        this.translatedAuthors = translatedAuthors;
        this.publisher = publisher;
        this.journal = journal;
        this.keywords = keywords;
        this.callNumber = callNumber;
        this.accessionNumber = accessionNumber;
        this.numberOrIssue = numberOrIssue;
        this.pages = pages;
        this.translatedTitle = translatedTitle;
        this.electronicResourceNumber = electronicResourceNumber;
        this.tertiaryTitle = tertiaryTitle;
        this.title = title;
        this.URL = URL;
        this.volume = volume;
        this.databaseProvider = databaseProvider;
        this.abstrct = abstrct;
        this.tertiaryAuthors = tertiaryAuthors;
        this.notes = notes;
        this.type = type;
        this.custom1 = custom1;
        this.custom2 = custom2;
        this.custom3 = custom3;
        this.custom4 = custom4;
        this.numberOfVolumes = numberOfVolumes;
        this.edition = edition;
        this.date = date;
        this.typeOfWork = typeOfWork;
        this.subsidiaryAuthors = subsidiaryAuthors;
        this.isbnOrIssn = isbnOrIssn;
        this.shortTitle = shortTitle;
        this.custom5 = custom5;
        this.custom6 = custom6;
        this.custom7 = custom7;
        this.section = section;
        this.originalPublication = originalPublication;
        this.reprintEdition = reprintEdition;
        this.reviewedItem = reviewedItem;
        this.authorAddress = authorAddress;
        this.caption = caption;
        this.linkToPDF = linkToPDF;
        this.researchNotes = researchNotes;
        this.accessDate = accessDate;
        this.lastModifiedDate = lastModifiedDate;
        this.nameOfDatabase = nameOfDatabase;

    }

    /**
     * @return the reference's authors
     */
    public String[] getAuthors() {
        return authors;
    }
    /**
     * @return the reference's bookOrConference
     */
    public String getBookOrConference() {
        return bookOrConference;
    }
    /**
     * @return the reference's place
     */
    public String getPlace() {
        return place;
    }
    /**
     * @return the reference's year
     */
    public String getYear() {
        return year;
    }
    /**
     * @return the reference's editors
     */
    public String[] getEditors() {
        return editors;
    }
    /**
     * @return the reference's label
     */
    public String getLabel() {
        return label;
    }
    /**
     * @return the reference's language
     */
    public String getLanguage() {
        return language;
    }
    /**
     * @return the reference's translatedAuthors
     */
    public String[] getTranslatedAuthors() {
        return translatedAuthors;
    }
    /**
     * @return the reference's publisher
     */
    public String getPublisher() {
        return publisher;
    }
    /**
     * @return the reference's journal
     */
    public String getJournal() {
        return journal;
    }
    /**
     * @return the reference's keywords
     */
    public String[] getKeywords() {
        return keywords;
    }
    /**
     * @return the reference's callNumber
     */
    public String getCallNumber() {
        return callNumber;
    }
    /**
     * @return the reference's accessionNumber
     */
    public String getAccessionNumber() {
        return accessionNumber;
    }
    /**
     * @return the reference's numberOrIssue
     */
    public String getNumberOrIssue() {
        return numberOrIssue;
    }
    /**
     * @return the reference's pages
     */
    public String getPages() {
        return pages;
    }
    /**
     * @return the reference's translatedTitle
     */
    public String getTranslatedTitle() {
        return translatedTitle;
    }
    /**
     * @return the reference's electronicResourceNumber
     */
    public String getElectronicResourceNumber() {
        return electronicResourceNumber;
    }
    /**
     * @return the reference's tertiaryTitle
     */
    public String getTertiaryTitle() {
        return tertiaryTitle;
    }
    /**
     * @return the reference's title
     */
    public String getTitle() {
        return title;
    }
    /**
     * @return the reference's URL
     */
    public String getURL() {
        return URL;
    }
    /**
     * @return the reference's volume
     */
    public String getVolume() {
        return volume;
    }
    /**
     * @return the reference's databaseProvider
     */
    public String getDatabaseProvider() {
        return databaseProvider;
    }
    /**
     * @return the reference's abstract
     */
    public String getAbstrct() {
        return abstrct;
    }
    /**
     * @return the reference's tertiaryAuthors
     */
    public String[] getTertiaryAuthors() {
        return tertiaryAuthors;
    }
    /**
     * @return the reference's notes
     */
    public String[] getNotes() {
        return notes;
    }
    /**
     * @return the reference's type
     */
    public EndNoteType getType() {
        return type;
    }
    /**
     * @return the reference's custom1
     */
    public String getCustom1() {
        return custom1;
    }
    /**
     * @return the reference's custom2
     */
    public String getCustom2() {
        return custom2;
    }
    /**
     * @return the reference's custom3
     */
    public String getCustom3() {
        return custom3;
    }
    /**
     * @return the reference's custom4
     */
    public String getCustom4() {
        return custom4;
    }
    /**
     * @return the reference's numberOfVolumes
     */
    public String getNumberOfVolumes() {
        return numberOfVolumes;
    }
    /**
     * @return the reference's edition
     */
    public String getEdition() {
        return edition;
    }
    /**
     * @return the reference's date
     */
    public String getDate() {
        return date;
    }
    /**
     * @return the reference's typeOfWork
     */
    public String getTypeOfWork() {
        return typeOfWork;
    }
    /**
     * @return the reference's subsidiaryAuthors
     */
    public String[] getSubsidiaryAuthors() {
        return subsidiaryAuthors;
    }
    /**
     * @return the reference's isbnOrIssn
     */
    public String getIsbnOrIssn() {
        return isbnOrIssn;
    }
    /**
     * @return the reference's shortTitle
     */
    public String getShortTitle() {
        return shortTitle;
    }
    /**
     * @return the reference's custom5
     */
    public String getCustom5() {
        return custom5;
    }
    /**
     * @return the reference's custom6
     */
    public String getCustom6() {
        return custom6;
    }
    /**
     * @return the reference's custom7
     */
    public String getCustom7() {
        return custom7;
    }
    /**
     * @return the reference's section
     */
    public String getSection() {
        return section;
    }
    /**
     * @return the reference's originalPublication
     */
    public String getOriginalPublication() {
        return originalPublication;
    }
    /**
     * @return the reference's reprintEdition
     */
    public String getReprintEdition() {
        return reprintEdition;
    }
    /**
     * @return the reference's reviewedItem
     */
    public String getReviewedItem() {
        return reviewedItem;
    }
    /**
     * @return the reference's authorAddress
     */
    public String getAuthorAddress() {
        return authorAddress;
    }
    /**
     * @return the reference's caption
     */
    public String getCaption() {
        return caption;
    }
    /**
     * @return the reference's linkToPDF
     */
    public String getLinkToPDF() {
        return linkToPDF;
    }
    /**
     * @return the reference's researchNotes
     */
    public String getResearchNotes() {
        return researchNotes;
    }
    /**
     * @return the reference's accessDate
     */
    public String getAccessDate() {
        return accessDate;
    }
    /**
     * @return the reference's lastModifiedDate
     */
    public String getLastModifiedDate() {
        return lastModifiedDate;
    }
    /**
     * @return the reference's nameOfDatabase
     */
    public String getNameOfDatabase() {
        return nameOfDatabase;
    }

    @Override
    public int hashCode() {
        int result = 1;

        result = 31 * result + Arrays.hashCode(authors);
        result = 31 * result + ((bookOrConference == null) ? 0 : bookOrConference.hashCode());
        result = 31 * result + ((place == null) ? 0 : place.hashCode());
        result = 31 * result + ((year == null) ? 0 : year.hashCode());
        result = 31 * result + Arrays.hashCode(editors);
        result = 31 * result + ((label == null) ? 0 : label.hashCode());
        result = 31 * result + ((language == null) ? 0 : language.hashCode());
        result = 31 * result + Arrays.hashCode(translatedAuthors);
        result = 31 * result + ((publisher == null) ? 0 : publisher.hashCode());
        result = 31 * result + ((journal == null) ? 0 : journal.hashCode());
        result = 31 * result + Arrays.hashCode(keywords);
        result = 31 * result + ((callNumber == null) ? 0 : callNumber.hashCode());
        result = 31 * result + ((accessionNumber == null) ? 0 : accessionNumber.hashCode());
        result = 31 * result + ((numberOrIssue == null) ? 0 : numberOrIssue.hashCode());
        result = 31 * result + ((pages == null) ? 0 : pages.hashCode());
        result = 31 * result + ((translatedTitle == null) ? 0 : translatedTitle.hashCode());
        result = 31 * result + ((electronicResourceNumber == null) ? 0 : electronicResourceNumber.hashCode());
        result = 31 * result + ((tertiaryTitle == null) ? 0 : tertiaryTitle.hashCode());
        result = 31 * result + ((title == null) ? 0 : title.hashCode());
        result = 31 * result + ((URL == null) ? 0 : URL.hashCode());
        result = 31 * result + ((volume == null) ? 0 : volume.hashCode());
        result = 31 * result + ((databaseProvider == null) ? 0 : databaseProvider.hashCode());
        result = 31 * result + ((abstrct == null) ? 0 : abstrct.hashCode());
        result = 31 * result + Arrays.hashCode(tertiaryAuthors);
        result = 31 * result + Arrays.hashCode(notes);
        result = 31 * result + ((type == null) ? 0 : type.hashCode());
        result = 31 * result + ((custom1 == null) ? 0 : custom1.hashCode());
        result = 31 * result + ((custom2 == null) ? 0 : custom2.hashCode());
        result = 31 * result + ((custom3 == null) ? 0 : custom3.hashCode());
        result = 31 * result + ((custom4 == null) ? 0 : custom4.hashCode());
        result = 31 * result + ((numberOfVolumes == null) ? 0 : numberOfVolumes.hashCode());
        result = 31 * result + ((edition == null) ? 0 : edition.hashCode());
        result = 31 * result + ((date == null) ? 0 : date.hashCode());
        result = 31 * result + ((typeOfWork == null) ? 0 : typeOfWork.hashCode());
        result = 31 * result + Arrays.hashCode(subsidiaryAuthors);
        result = 31 * result + ((isbnOrIssn == null) ? 0 : isbnOrIssn.hashCode());
        result = 31 * result + ((shortTitle == null) ? 0 : shortTitle.hashCode());
        result = 31 * result + ((custom5 == null) ? 0 : custom5.hashCode());
        result = 31 * result + ((custom6 == null) ? 0 : custom6.hashCode());
        result = 31 * result + ((custom7 == null) ? 0 : custom7.hashCode());
        result = 31 * result + ((section == null) ? 0 : section.hashCode());
        result = 31 * result + ((originalPublication == null) ? 0 : originalPublication.hashCode());
        result = 31 * result + ((reprintEdition == null) ? 0 : reprintEdition.hashCode());
        result = 31 * result + ((reviewedItem == null) ? 0 : reviewedItem.hashCode());
        result = 31 * result + ((authorAddress == null) ? 0 : authorAddress.hashCode());
        result = 31 * result + ((caption == null) ? 0 : caption.hashCode());
        result = 31 * result + ((linkToPDF == null) ? 0 : linkToPDF.hashCode());
        result = 31 * result + ((researchNotes == null) ? 0 : researchNotes.hashCode());
        result = 31 * result + ((accessDate == null) ? 0 : accessDate.hashCode());
        result = 31 * result + ((lastModifiedDate == null) ? 0 : lastModifiedDate.hashCode());
        result = 31 * result + ((nameOfDatabase == null) ? 0 : nameOfDatabase.hashCode());

        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof EndNoteReference))
            return false;
        EndNoteReference other = (EndNoteReference) obj;

        if (!Arrays.equals(authors, other.authors))
            return false;

        if (bookOrConference == null) {
            if (other.bookOrConference != null)
                return false;
        } else if (!bookOrConference.equals(other.bookOrConference))
            return false;

        if (place == null) {
            if (other.place != null)
                return false;
        } else if (!place.equals(other.place))
            return false;

        if (year == null) {
            if (other.year != null)
                return false;
        } else if (!year.equals(other.year))
            return false;

        if (!Arrays.equals(editors, other.editors))
            return false;

        if (label == null) {
            if (other.label != null)
                return false;
        } else if (!label.equals(other.label))
            return false;

        if (language == null) {
            if (other.language != null)
                return false;
        } else if (!language.equals(other.language))
            return false;

        if (!Arrays.equals(translatedAuthors, other.translatedAuthors))
            return false;

        if (publisher == null) {
            if (other.publisher != null)
                return false;
        } else if (!publisher.equals(other.publisher))
            return false;

        if (journal == null) {
            if (other.journal != null)
                return false;
        } else if (!journal.equals(other.journal))
            return false;

        if (!Arrays.equals(keywords, other.keywords))
            return false;

        if (callNumber == null) {
            if (other.callNumber != null)
                return false;
        } else if (!callNumber.equals(other.callNumber))
            return false;

        if (accessionNumber == null) {
            if (other.accessionNumber != null)
                return false;
        } else if (!accessionNumber.equals(other.accessionNumber))
            return false;

        if (numberOrIssue == null) {
            if (other.numberOrIssue != null)
                return false;
        } else if (!numberOrIssue.equals(other.numberOrIssue))
            return false;

        if (pages == null) {
            if (other.pages != null)
                return false;
        } else if (!pages.equals(other.pages))
            return false;

        if (translatedTitle == null) {
            if (other.translatedTitle != null)
                return false;
        } else if (!translatedTitle.equals(other.translatedTitle))
            return false;

        if (electronicResourceNumber == null) {
            if (other.electronicResourceNumber != null)
                return false;
        } else if (!electronicResourceNumber.equals(other.electronicResourceNumber))
            return false;

        if (tertiaryTitle == null) {
            if (other.tertiaryTitle != null)
                return false;
        } else if (!tertiaryTitle.equals(other.tertiaryTitle))
            return false;

        if (title == null) {
            if (other.title != null)
                return false;
        } else if (!title.equals(other.title))
            return false;

        if (URL == null) {
            if (other.URL != null)
                return false;
        } else if (!URL.equals(other.URL))
            return false;

        if (volume == null) {
            if (other.volume != null)
                return false;
        } else if (!volume.equals(other.volume))
            return false;

        if (databaseProvider == null) {
            if (other.databaseProvider != null)
                return false;
        } else if (!databaseProvider.equals(other.databaseProvider))
            return false;

        if (abstrct == null) {
            if (other.abstrct != null)
                return false;
        } else if (!abstrct.equals(other.abstrct))
            return false;

        if (!Arrays.equals(tertiaryAuthors, other.tertiaryAuthors))
            return false;

        if (!Arrays.equals(notes, other.notes))
            return false;

        if (type == null) {
            if (other.type != null)
                return false;
        } else if (!type.equals(other.type))
            return false;

        if (custom1 == null) {
            if (other.custom1 != null)
                return false;
        } else if (!custom1.equals(other.custom1))
            return false;

        if (custom2 == null) {
            if (other.custom2 != null)
                return false;
        } else if (!custom2.equals(other.custom2))
            return false;

        if (custom3 == null) {
            if (other.custom3 != null)
                return false;
        } else if (!custom3.equals(other.custom3))
            return false;

        if (custom4 == null) {
            if (other.custom4 != null)
                return false;
        } else if (!custom4.equals(other.custom4))
            return false;

        if (numberOfVolumes == null) {
            if (other.numberOfVolumes != null)
                return false;
        } else if (!numberOfVolumes.equals(other.numberOfVolumes))
            return false;

        if (edition == null) {
            if (other.edition != null)
                return false;
        } else if (!edition.equals(other.edition))
            return false;

        if (date == null) {
            if (other.date != null)
                return false;
        } else if (!date.equals(other.date))
            return false;

        if (typeOfWork == null) {
            if (other.typeOfWork != null)
                return false;
        } else if (!typeOfWork.equals(other.typeOfWork))
            return false;

        if (!Arrays.equals(subsidiaryAuthors, other.subsidiaryAuthors))
            return false;

        if (isbnOrIssn == null) {
            if (other.isbnOrIssn != null)
                return false;
        } else if (!isbnOrIssn.equals(other.isbnOrIssn))
            return false;

        if (shortTitle == null) {
            if (other.shortTitle != null)
                return false;
        } else if (!shortTitle.equals(other.shortTitle))
            return false;

        if (custom5 == null) {
            if (other.custom5 != null)
                return false;
        } else if (!custom5.equals(other.custom5))
            return false;

        if (custom6 == null) {
            if (other.custom6 != null)
                return false;
        } else if (!custom6.equals(other.custom6))
            return false;

        if (custom7 == null) {
            if (other.custom7 != null)
                return false;
        } else if (!custom7.equals(other.custom7))
            return false;

        if (section == null) {
            if (other.section != null)
                return false;
        } else if (!section.equals(other.section))
            return false;

        if (originalPublication == null) {
            if (other.originalPublication != null)
                return false;
        } else if (!originalPublication.equals(other.originalPublication))
            return false;

        if (reprintEdition == null) {
            if (other.reprintEdition != null)
                return false;
        } else if (!reprintEdition.equals(other.reprintEdition))
            return false;

        if (reviewedItem == null) {
            if (other.reviewedItem != null)
                return false;
        } else if (!reviewedItem.equals(other.reviewedItem))
            return false;

        if (authorAddress == null) {
            if (other.authorAddress != null)
                return false;
        } else if (!authorAddress.equals(other.authorAddress))
            return false;

        if (caption == null) {
            if (other.caption != null)
                return false;
        } else if (!caption.equals(other.caption))
            return false;

        if (linkToPDF == null) {
            if (other.linkToPDF != null)
                return false;
        } else if (!linkToPDF.equals(other.linkToPDF))
            return false;

        if (researchNotes == null) {
            if (other.researchNotes != null)
                return false;
        } else if (!researchNotes.equals(other.researchNotes))
            return false;

        if (accessDate == null) {
            if (other.accessDate != null)
                return false;
        } else if (!accessDate.equals(other.accessDate))
            return false;

        if (lastModifiedDate == null) {
            if (other.lastModifiedDate != null)
                return false;
        } else if (!lastModifiedDate.equals(other.lastModifiedDate))
            return false;

        if (nameOfDatabase == null) {
            if (other.nameOfDatabase != null)
                return false;
        } else if (!nameOfDatabase.equals(other.nameOfDatabase))
            return false;

        return true;
    }
}
