package de.undercouch.citeproc.output;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

/**
 * A generated citation that can be put into the text
 * 
 * @author Michel Kraemer
 */
public class Citation {
    private final int index;
    private final String text;

    public Citation(int index, String text) {
        this.index = index;
        this.text = text;

    }

    /**
     * @return the citation's index
     */
    public int getIndex() {
        return index;
    }
    /**
     * @return the citation's text
     */
    public String getText() {
        return text;
    }

    @Override
    public int hashCode() {
        int result = 1;

        result = 31 * result + Objects.hashCode(index);
        result = 31 * result + ((text == null) ? 0 : text.hashCode());

        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Citation))
            return false;
        Citation other = (Citation) obj;

        if (index != other.index)
            return false;

        if (text == null) {
            if (other.text != null)
                return false;
        } else if (!text.equals(other.text))
            return false;

        return true;
    }
}
