package de.undercouch.citeproc.ris;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A container for RIS references
 * 
 * @author Michel Kraemer
 */
public class RISLibrary {
    private final List<RISReference> references = new ArrayList<>();

    /**
     * Adds a reference to this library
     * 
     * @param reference
     *            the reference to add
     */
    public void addReference(RISReference reference) {
        references.add(reference);
    }

    /**
     * @return an unmodifiable list of references in this library
     */
    public List<RISReference> getReferences() {
        return Collections.unmodifiableList(references);
    }
}
