package de.undercouch.citeproc.ris;

/**
 * Valid RIS reference types.
 * 
 * @author Michel Kraemer
 */
public enum RISType {
    ABST("ABST"), ADVS("ADVS"), AGGR("AGGR"), ANCIENT("ANCIENT"), ART("ART"), BILL("BILL"), BLOG("BLOG"), BOOK(
            "BOOK"), CASE("CASE"), CHAP("CHAP"), CHART("CHART"), CLSWK("CLSWK"), COMP("COMP"), CONF("CONF"), CPAPER(
                    "CPAPER"), CTLG("CTLG"), DATA("DATA"), DBASE("DBASE"), DICT("DICT"), EBOOK("EBOOK"), ECHAP(
                            "ECHAP"), EDBOOK("EDBOOK"), EJOUR("EJOUR"), ELEC("ELEC"), ENCYC("ENCYC"), EQUA(
                                    "EQUA"), FIGURE("FIGURE"), GEN("GEN"), GOVDOC("GOVDOC"), GRANT("GRANT"), HEAR(
                                            "HEAR"), ICOMM("ICOMM"), INPR("INPR"), JFULL("JFULL"), JOUR("JOUR"), LEGAL(
                                                    "LEGAL"), MANSCPT("MANSCPT"), MAP("MAP"), MGZN("MGZN"), MPCT(
                                                            "MPCT"), MULTI("MULTI"), MUSIC("MUSIC"), NEWS("NEWS"), PAMP(
                                                                    "PAMP"), PAT("PAT"), PCOMM("PCOMM"), RPRT(
                                                                            "RPRT"), SER("SER"), SLIDE("SLIDE"), SOUND(
                                                                                    "SOUND"), STAND("STAND"), STAT(
                                                                                            "STAT"), STD("STD"), THES(
                                                                                                    "THES"), UNPB(
                                                                                                            "UNPB"), VIDEO(
                                                                                                                    "VIDEO");

    private String name;

    RISType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    /**
     * Converts the given string to a RISType
     * 
     * @param str
     *            the string
     * @return the converted RISType
     */
    public static RISType fromString(String str) {
        if (str.equals("ABST")) {
            return ABST;
        }
        if (str.equals("ADVS")) {
            return ADVS;
        }
        if (str.equals("AGGR")) {
            return AGGR;
        }
        if (str.equals("ANCIENT")) {
            return ANCIENT;
        }
        if (str.equals("ART")) {
            return ART;
        }
        if (str.equals("BILL")) {
            return BILL;
        }
        if (str.equals("BLOG")) {
            return BLOG;
        }
        if (str.equals("BOOK")) {
            return BOOK;
        }
        if (str.equals("CASE")) {
            return CASE;
        }
        if (str.equals("CHAP")) {
            return CHAP;
        }
        if (str.equals("CHART")) {
            return CHART;
        }
        if (str.equals("CLSWK")) {
            return CLSWK;
        }
        if (str.equals("COMP")) {
            return COMP;
        }
        if (str.equals("CONF")) {
            return CONF;
        }
        if (str.equals("CPAPER")) {
            return CPAPER;
        }
        if (str.equals("CTLG")) {
            return CTLG;
        }
        if (str.equals("DATA")) {
            return DATA;
        }
        if (str.equals("DBASE")) {
            return DBASE;
        }
        if (str.equals("DICT")) {
            return DICT;
        }
        if (str.equals("EBOOK")) {
            return EBOOK;
        }
        if (str.equals("ECHAP")) {
            return ECHAP;
        }
        if (str.equals("EDBOOK")) {
            return EDBOOK;
        }
        if (str.equals("EJOUR")) {
            return EJOUR;
        }
        if (str.equals("ELEC")) {
            return ELEC;
        }
        if (str.equals("ENCYC")) {
            return ENCYC;
        }
        if (str.equals("EQUA")) {
            return EQUA;
        }
        if (str.equals("FIGURE")) {
            return FIGURE;
        }
        if (str.equals("GEN")) {
            return GEN;
        }
        if (str.equals("GOVDOC")) {
            return GOVDOC;
        }
        if (str.equals("GRANT")) {
            return GRANT;
        }
        if (str.equals("HEAR")) {
            return HEAR;
        }
        if (str.equals("ICOMM")) {
            return ICOMM;
        }
        if (str.equals("INPR")) {
            return INPR;
        }
        if (str.equals("JFULL")) {
            return JFULL;
        }
        if (str.equals("JOUR")) {
            return JOUR;
        }
        if (str.equals("LEGAL")) {
            return LEGAL;
        }
        if (str.equals("MANSCPT")) {
            return MANSCPT;
        }
        if (str.equals("MAP")) {
            return MAP;
        }
        if (str.equals("MGZN")) {
            return MGZN;
        }
        if (str.equals("MPCT")) {
            return MPCT;
        }
        if (str.equals("MULTI")) {
            return MULTI;
        }
        if (str.equals("MUSIC")) {
            return MUSIC;
        }
        if (str.equals("NEWS")) {
            return NEWS;
        }
        if (str.equals("PAMP")) {
            return PAMP;
        }
        if (str.equals("PAT")) {
            return PAT;
        }
        if (str.equals("PCOMM")) {
            return PCOMM;
        }
        if (str.equals("RPRT")) {
            return RPRT;
        }
        if (str.equals("SER")) {
            return SER;
        }
        if (str.equals("SLIDE")) {
            return SLIDE;
        }
        if (str.equals("SOUND")) {
            return SOUND;
        }
        if (str.equals("STAND")) {
            return STAND;
        }
        if (str.equals("STAT")) {
            return STAT;
        }
        if (str.equals("STD")) {
            return STD;
        }
        if (str.equals("THES")) {
            return THES;
        }
        if (str.equals("UNPB")) {
            return UNPB;
        }
        if (str.equals("VIDEO")) {
            return VIDEO;
        }
        throw new IllegalArgumentException("Unknown RISType: " + str);
    }
}
