/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.bibtex;

import de.undercouch.citeproc.bibtex.PageRange;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PageRanges
extends AbstractList<PageRange> {
    private final List<PageRange> list = new ArrayList<PageRange>();

    public PageRanges() {
    }

    public PageRanges(PageRange singleRange) {
        this.list.add(singleRange);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public PageRange get(int index) {
        return this.list.get(index);
    }

    @Override
    public PageRange set(int index, PageRange element) {
        return this.list.set(index, element);
    }

    @Override
    public boolean add(PageRange pageRange) {
        return this.list.add(pageRange);
    }

    @Override
    public PageRange remove(int index) {
        return this.list.remove(index);
    }

    public String getLiteral() {
        return this.list.stream().map(PageRange::getLiteral).collect(Collectors.joining(", "));
    }

    public String getPageFirst() {
        String first = null;
        for (PageRange pr : this.list) {
            if (first == null) {
                first = pr.getPageFirst();
                continue;
            }
            if (pr.getPageFirst() == null || !StringUtils.isNumeric((CharSequence)first) || !StringUtils.isNumeric((CharSequence)first)) continue;
            int pp1 = Integer.parseInt(first);
            int pp2 = Integer.parseInt(pr.getPageFirst());
            if (pp2 >= pp1) continue;
            first = pr.getPageFirst();
        }
        return first;
    }

    public Integer getNumberOfPages() {
        List filteredList = this.list.stream().filter(pr -> pr.getNumberOfPages() != null).collect(Collectors.toList());
        if (filteredList.isEmpty()) {
            return null;
        }
        return filteredList.stream().mapToInt(PageRange::getNumberOfPages).sum();
    }

    public boolean isMultiplePages() {
        return this.list.size() > 1 || this.list.stream().anyMatch(PageRange::isMultiplePages);
    }
}

