/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;

public class Token {
    private final String text;
    private final Type type;
    private final int formattingAttributes;
    private final boolean firstField;

    private Token(String text, Type type, int formattingAttributes, boolean firstField) {
        this.text = text;
        this.type = type;
        this.formattingAttributes = formattingAttributes;
        this.firstField = firstField;
    }

    public String getText() {
        return this.text;
    }

    public Type getType() {
        return this.type;
    }

    public int getFormattingAttributes() {
        return this.formattingAttributes;
    }

    public boolean isFirstField() {
        return this.firstField;
    }

    public String toString() {
        return this.text;
    }

    public static class Builder {
        private String text;
        private Type type;
        private int formattingAttributes;
        private boolean firstField;

        public Builder() {
        }

        public Builder(Token token) {
            this.text = token.text;
            this.type = token.type;
            this.formattingAttributes = token.formattingAttributes;
            this.firstField = token.firstField;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder mergeFormattingAttributes(int formattingAttributes) {
            this.formattingAttributes = FormattingAttributes.merge(formattingAttributes, this.formattingAttributes);
            return this;
        }

        public Builder firstField(boolean firstField) {
            this.firstField = firstField;
            return this;
        }

        public Token build() {
            return new Token(this.text, this.type, this.formattingAttributes, this.firstField);
        }
    }

    public static enum Type {
        TEXT,
        OPEN_QUOTE,
        CLOSE_QUOTE,
        PREFIX,
        SUFFIX,
        DELIMITER,
        URL,
        DOI;

    }
}

