/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.internal.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TokenBuffer {
    private final List<Token> tokens;

    public TokenBuffer() {
        this.tokens = new ArrayList<Token>();
    }

    private TokenBuffer(List<Token> tokens) {
        this.tokens = tokens;
    }

    public TokenBuffer append(Token token) {
        this.tokens.add(token);
        return this;
    }

    public TokenBuffer prepend(Token token) {
        this.tokens.add(0, token);
        return this;
    }

    public TokenBuffer append(String text, Token.Type type) {
        return this.append(new Token.Builder().text(text).type(type).build());
    }

    public TokenBuffer prepend(String text, Token.Type type) {
        return this.prepend(new Token.Builder().text(text).type(type).build());
    }

    public TokenBuffer append(String text, Token.Type type, int formattingAttributes) {
        return this.append(new Token.Builder().text(text).type(type).mergeFormattingAttributes(formattingAttributes).build());
    }

    public TokenBuffer prepend(String text, Token.Type type, int formattingAttributes) {
        return this.prepend(new Token.Builder().text(text).type(type).mergeFormattingAttributes(formattingAttributes).build());
    }

    public TokenBuffer append(TokenBuffer other) {
        this.tokens.addAll(other.tokens);
        return this;
    }

    public TokenBuffer prepend(TokenBuffer other) {
        this.tokens.addAll(0, other.tokens);
        return this;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public TokenBuffer copy(int fromIndex, int toIndex) {
        return new TokenBuffer(this.tokens.subList(fromIndex, toIndex));
    }

    public String toString() {
        return this.tokens.stream().map(Token::toString).collect(Collectors.joining());
    }
}

