/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SBibliography;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.format.BaseFormat;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.SecondFieldAlign;
import org.apache.commons.text.StringEscapeUtils;

public class FoFormat
extends BaseFormat {
    private final String columnWidth;

    public FoFormat() {
        this("2.5em");
    }

    public FoFormat(String columnWidth) {
        this.columnWidth = columnWidth;
    }

    @Override
    public String getName() {
        return "fo";
    }

    @Override
    protected String doFormatCitation(TokenBuffer buffer, RenderContext ctx) {
        return this.format(buffer);
    }

    @Override
    protected String doFormatBibliographyEntry(TokenBuffer buffer, RenderContext ctx, int index) {
        String result;
        SecondFieldAlign sfa = ctx.getStyle().getBibliography().getSecondFieldAlign();
        if (sfa != SecondFieldAlign.FALSE && !buffer.getTokens().isEmpty()) {
            int i = 0;
            while (buffer.getTokens().get(i).isFirstField()) {
                ++i;
            }
            TokenBuffer firstBuffer = buffer.copy(0, i);
            TokenBuffer restBuffer = buffer.copy(i, buffer.getTokens().size());
            result = "\n  <fo:table table-layout=\"fixed\" width=\"100%\">\n    <fo:table-column column-number=\"1\" column-width=\"" + this.columnWidth + "\"/>\n    <fo:table-column column-number=\"2\" column-width=\"proportional-column-width(1)\"/>\n    <fo:table-body>\n      <fo:table-row>\n        <fo:table-cell>\n          <fo:block>" + this.format(firstBuffer) + "</fo:block>\n        </fo:table-cell>\n        <fo:table-cell>\n          <fo:block>" + this.format(restBuffer) + "</fo:block>\n        </fo:table-cell>\n      </fo:table-row>\n    </fo:table-body>\n  </fo:table>\n";
        } else {
            result = this.format(buffer);
        }
        return "<fo:block id=\"" + ctx.getCitationItem().getId() + "\">" + result + "</fo:block>\n";
    }

    @Override
    protected String doFormatLink(String text, String uri) {
        return "<fo:basic-link external-destination=\"url('" + uri + "')\">" + text + "</fo:basic-link>";
    }

    @Override
    public Bibliography makeBibliography(String[] entries, SBibliography bibliographyElement) {
        SecondFieldAlign sfa = bibliographyElement.getSecondFieldAlign();
        return new Bibliography(entries, null, null, null, null, null, null, null, null, sfa);
    }

    @Override
    protected String escape(String str) {
        return StringEscapeUtils.escapeXml11((String)str);
    }

    @Override
    protected String openFontStyle(int fontStyle) {
        if (fontStyle == 2) {
            return "<fo:inline font-style=\"italic\">";
        }
        return "<fo:inline font-style=\"oblique\">";
    }

    @Override
    protected String closeFontStyle(int fontStyle) {
        return "</fo:inline>";
    }

    @Override
    protected String openFontVariant(int fontVariant) {
        return "<fo:inline font-variant=\"small-caps\">";
    }

    @Override
    protected String closeFontVariant(int fontVariant) {
        return "</fo:inline>";
    }

    @Override
    protected String openFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "<fo:inline font-weight=\"bold\">";
        }
        return "<fo:inline font-weight=\"lighter\">";
    }

    @Override
    protected String closeFontWeight(int fontWeight) {
        return "</fo:inline>";
    }

    @Override
    protected String openTextDecoration(int textDecoration) {
        return "<fo:inline text-decoration=\"underline\">";
    }

    @Override
    protected String closeTextDecoration(int textDecoration) {
        return "</fo:inline>";
    }

    @Override
    protected String openVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "<fo:inline vertical-align=\"super\">";
        }
        return "<fo:inline vertical-align=\"sub\">";
    }

    @Override
    protected String closeVerticalAlign(int verticalAlign) {
        return "</fo:inline>";
    }
}

