/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.locale.LDate;
import de.undercouch.citeproc.csl.internal.rendering.SDatePart;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.helper.NodeHelper;
import de.undercouch.citeproc.helper.time.AnyDateParser;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDate
implements SRenderingElement {
    private static final String[] NAMES = new String[]{"year", "month", "day"};
    private final String variable;
    private final String form;
    private final String datePartsAttr;
    private final List<SDatePart> dateParts = new ArrayList<SDatePart>();
    private final Affixes affixes;

    public SDate(Node node) {
        String datePartsAttr;
        this.variable = NodeHelper.getAttrValue(node, "variable");
        if (this.variable == null || this.variable.isEmpty()) {
            throw new IllegalStateException("Date element does not select a variable");
        }
        String form = NodeHelper.getAttrValue(node, "form");
        if (!"text".equals(form) && !"numeric".equals(form)) {
            form = null;
        }
        this.form = form;
        this.datePartsAttr = this.form != null ? ("year-month-day".equals(datePartsAttr = NodeHelper.getAttrValue(node, "date-parts")) || "year-month".equals(datePartsAttr) || "year".equals(datePartsAttr) ? datePartsAttr : "year-month-day") : null;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            String nodeName = c.getNodeName();
            if (!"date-part".equals(nodeName)) continue;
            this.dateParts.add(new SDatePart(c));
        }
        this.affixes = new Affixes(node);
    }

    @Override
    public void render(RenderContext ctx) {
        this.affixes.wrap(this::renderInternal).accept(ctx);
    }

    private void renderInternal(RenderContext ctx) {
        String literal;
        Object dps;
        CSLDate date;
        block21: {
            date = ctx.getDateVariable(this.variable, true);
            if (date == null) {
                ctx.getVariableListeners().forEach(v -> v.onFetchDateVariable(this.variable, null));
                return;
            }
            dps = date.getDateParts();
            literal = date.getLiteral();
            if (dps == null && date.getRaw() != null) {
                try {
                    TemporalAccessor ta = AnyDateParser.parse(date.getRaw(), ctx.getLocale().getLang());
                    if (ta.isSupported(ChronoField.YEAR)) {
                        dps = ta.isSupported(ChronoField.MONTH_OF_YEAR) ? (ta.isSupported(ChronoField.DAY_OF_MONTH) ? (Object)new int[][]{{ta.get(ChronoField.YEAR), ta.get(ChronoField.MONTH_OF_YEAR), ta.get(ChronoField.DAY_OF_MONTH)}} : (Object)new int[][]{{ta.get(ChronoField.YEAR), ta.get(ChronoField.MONTH_OF_YEAR)}}) : (Object)new int[][]{{ta.get(ChronoField.YEAR)}};
                    }
                }
                catch (IllegalArgumentException e) {
                    if (literal != null) break block21;
                    literal = date.getRaw();
                }
            }
        }
        boolean notifyListenersEmpty = true;
        if (dps != null && ((int[][])dps).length > 0) {
            List<SDatePart> dateParts;
            int[] first = dps[0];
            int[] last = dps[((int[][])dps).length - 1];
            if (first.length != last.length) {
                throw new IllegalStateException("Elements in date range must have the same length");
            }
            RenderContext left = new RenderContext(ctx);
            RenderContext right = new RenderContext(ctx);
            RenderContext result = new RenderContext(ctx);
            if (this.form != null && ctx.getLocale().getDateFormats() != null) {
                dateParts = new ArrayList<SDatePart>();
                LDate d = ctx.getLocale().getDateFormats().get(this.form);
                if (d != null) {
                    for (SDatePart datePart : d.getDateParts()) {
                        if ("year".equals(datePart.getName())) {
                            dateParts.add(datePart);
                            continue;
                        }
                        if ("month".equals(datePart.getName()) && ("year-month-day".equals(this.datePartsAttr) || "year-month".equals(this.datePartsAttr))) {
                            dateParts.add(datePart);
                            continue;
                        }
                        if (!"day".equals(datePart.getName()) || !"year-month-day".equals(this.datePartsAttr)) continue;
                        dateParts.add(datePart);
                    }
                }
            } else {
                dateParts = this.dateParts;
            }
            for (SDatePart dp : dateParts) {
                boolean shouldMerge;
                int len = ArrayUtils.indexOf((Object[])NAMES, (Object)dp.getName());
                boolean bl = shouldMerge = first.length > len;
                if (shouldMerge) {
                    for (int i = 0; i <= len; ++i) {
                        if (first[i] == last[i]) continue;
                        shouldMerge = false;
                        break;
                    }
                }
                if (shouldMerge) {
                    this.merge(left, right, result);
                    left = new RenderContext(ctx);
                    right = new RenderContext(ctx);
                    dp.setDate(first);
                    dp.render(result);
                    continue;
                }
                dp.setDate(first);
                dp.render(left);
                dp.setDate(last);
                dp.render(right);
            }
            this.merge(left, right, result);
            notifyListenersEmpty = result.getResult().isEmpty();
            ctx.emit(result.getResult());
        } else if (literal != null) {
            notifyListenersEmpty = literal.isEmpty();
            ctx.emit(literal);
        }
        if (notifyListenersEmpty) {
            ctx.getVariableListeners().forEach(v -> v.onFetchDateVariable(this.variable, null));
        } else {
            ctx.getVariableListeners().forEach(v -> v.onFetchDateVariable(this.variable, date));
        }
    }

    private void merge(RenderContext left, RenderContext right, RenderContext result) {
        if (!left.getResult().isEmpty() && !right.getResult().isEmpty()) {
            List<Token> leftTokens = left.getResult().getTokens();
            for (int i = 0; i < leftTokens.size(); ++i) {
                Token t = leftTokens.get(i);
                if (i >= leftTokens.size() - 1 && t.getType() == Token.Type.SUFFIX) continue;
                result.emit(t);
            }
            result.emit("\u2013");
            List<Token> rightTokens = right.getResult().getTokens();
            for (int i = 0; i < rightTokens.size(); ++i) {
                Token t = rightTokens.get(i);
                if (i <= 0 && t.getType() == Token.Type.PREFIX) continue;
                result.emit(t);
            }
        } else if (!left.getResult().isEmpty()) {
            result.emit(left.getResult());
        } else if (!right.getResult().isEmpty()) {
            result.emit(right.getResult());
        }
    }
}

