/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering.condition;

import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLType;
import de.undercouch.citeproc.csl.internal.GeneratedCitation;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.helper.NumberElement;
import de.undercouch.citeproc.csl.internal.helper.NumberParser;
import de.undercouch.citeproc.csl.internal.rendering.condition.SCondition;
import de.undercouch.citeproc.helper.NodeHelper;
import de.undercouch.citeproc.helper.NumberHelper;
import java.util.List;
import org.w3c.dom.Node;

public class SIf
extends SCondition {
    private static final int ALL = 0;
    private static final int ANY = 1;
    private static final int NONE = 2;
    private final String[] types;
    private final String[] variables;
    private final String[] isNumerics;
    private final String[] numbers;
    private final String[] positions;
    private final int match;

    public SIf(Node node) {
        super(node);
        String type = NodeHelper.getAttrValue(node, "type");
        this.types = type != null ? type.split("\\s+") : null;
        String variable = NodeHelper.getAttrValue(node, "variable");
        this.variables = variable != null ? variable.split("\\s+") : null;
        String isNumeric = NodeHelper.getAttrValue(node, "is-numeric");
        this.isNumerics = isNumeric != null ? isNumeric.split("\\s+") : null;
        String number = NodeHelper.getAttrValue(node, "number");
        this.numbers = number != null ? number.split("\\s+") : null;
        String position = NodeHelper.getAttrValue(node, "position");
        this.positions = position != null ? position.split("\\s+") : null;
        String match = NodeHelper.getAttrValue(node, "match");
        if (match == null || match.equals("all")) {
            this.match = 0;
        } else if (match.equals("any")) {
            this.match = 1;
        } else if (match.equals("none")) {
            this.match = 2;
        } else {
            throw new IllegalStateException("Unknown match mode: " + match);
        }
    }

    @Override
    public boolean matches(RenderContext ctx) {
        if (this.types == null && this.variables == null && this.isNumerics == null && this.numbers == null && this.positions == null) {
            return false;
        }
        Boolean mt = this.matchesType(ctx);
        if (mt != null) {
            return mt;
        }
        Boolean mv = this.matchesVariable(ctx);
        if (mv != null) {
            return mv;
        }
        Boolean mne = this.matchesNumerics(ctx);
        if (mne != null) {
            return mne;
        }
        Boolean mnb = this.matchesNumbers(ctx);
        if (mnb != null) {
            return mnb;
        }
        Boolean mnp = this.matchesPositions(ctx);
        if (mnp != null) {
            return mnp;
        }
        return this.match != 1;
    }

    private Boolean matchesType(RenderContext ctx) {
        CSLType cslType = ctx.getItemData().getType();
        if (this.types != null && cslType != null) {
            String type = cslType.toString();
            for (String s : this.types) {
                boolean r = type.equals(s);
                if (this.match == 0 && !r) {
                    return Boolean.FALSE;
                }
                if (this.match == 1 && r) {
                    return Boolean.TRUE;
                }
                if (this.match != 2 || !r) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private Boolean matchesVariable(RenderContext ctx) {
        if (this.variables != null) {
            for (String v : this.variables) {
                Object o = ctx.getVariable(v, true);
                if (this.match == 0 && o == null) {
                    return Boolean.FALSE;
                }
                if (this.match == 1 && o != null) {
                    return Boolean.TRUE;
                }
                if (this.match != 2 || o == null) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private Boolean matchesNumerics(RenderContext ctx) {
        if (this.isNumerics != null) {
            for (String v : this.isNumerics) {
                boolean numeric;
                Object o = ctx.getVariable(v, true);
                boolean bl = numeric = o != null && (o instanceof Number || NumberHelper.isNumeric(String.valueOf(o)));
                if (this.match == 0 && !numeric) {
                    return Boolean.FALSE;
                }
                if (this.match == 1 && numeric) {
                    return Boolean.TRUE;
                }
                if (this.match != 2 || !numeric) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private Boolean matchesNumbers(RenderContext ctx) {
        if (this.numbers != null) {
            List<NumberElement> elements;
            String v = ctx.getStringVariable("number", true);
            String firstLabel = null;
            if (v != null && (elements = NumberParser.parse(v)).get(0).getLabel() != null) {
                firstLabel = elements.get(0).getLabel().toString();
            }
            if (firstLabel == null) {
                firstLabel = "number";
            }
            for (String number : this.numbers) {
                if (this.match == 0 && !number.equals(firstLabel)) {
                    return Boolean.FALSE;
                }
                if (this.match == 1 && number.equals(firstLabel)) {
                    return Boolean.TRUE;
                }
                if (this.match != 2 || !number.equals(firstLabel)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private boolean isFirstCitation(RenderContext ctx) {
        List<GeneratedCitation> gcs = ctx.getGeneratedCitations();
        for (GeneratedCitation gc : gcs) {
            for (CSLCitationItem preparedItem : gc.getPrepared().getCitationItems()) {
                if (!preparedItem.getId().equals(ctx.getCitationItem().getId())) continue;
                return false;
            }
        }
        CSLCitationItem firstItem = ctx.getCitation().getCitationItems()[0];
        return firstItem == ctx.getCitationItem();
    }

    private boolean isIbid(RenderContext ctx) {
        CSLCitationItem currentItem = ctx.getCitationItem();
        CSLCitationItem[] citationItems = ctx.getCitation().getCitationItems();
        for (int i = 0; i < citationItems.length; ++i) {
            CSLCitationItem item = citationItems[i];
            if (item != currentItem) continue;
            if (i > 0) {
                return citationItems[i - 1].getId().equals(currentItem.getId());
            }
            List<GeneratedCitation> gcs = ctx.getGeneratedCitations();
            if (gcs == null || gcs.size() <= 0) break;
            CSLCitationItem[] gcis = gcs.get(gcs.size() - 1).getPrepared().getCitationItems();
            return gcis.length == 1 && gcis[0].getId().equals(currentItem.getId());
        }
        return false;
    }

    private Boolean matchesPositions(RenderContext ctx) {
        if (this.positions != null) {
            if (ctx.getGeneratedCitations() == null) {
                if (this.match == 0) {
                    return Boolean.FALSE;
                }
                return null;
            }
            for (String position : this.positions) {
                boolean b = position.equals("first") ? this.isFirstCitation(ctx) : (position.equals("ibid") ? this.isIbid(ctx) : false);
                if (this.match == 0 && !b) {
                    return Boolean.FALSE;
                }
                if (this.match == 1 && b) {
                    return Boolean.TRUE;
                }
                if (this.match != 2 || !b) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

