/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.time;

import de.undercouch.citeproc.helper.time.ParsedDate;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AnyDateParser {
    private static final int FLY = 1;
    private static final int FSY = 2;
    private static final int FMN = 4;
    private static final int FM = 8;
    private static final int FD = 16;
    private static final int FS = 32;
    private static final String GROUPNAME_DAY = "day";
    private static final String GROUPNAME_MONTHNAME = "monthname";
    private static final String GROUPNAME_MONTH = "month";
    private static final String GROUPNAME_LONGYEAR = "longyear";
    private static final String GROUPNAME_SHORTYEAR = "shortyear";
    private static final List<CompiledPattern> englishPatterns = AnyDateParser.makePatterns(Locale.ENGLISH);
    private static final Map<String, Long> englishMonthIndexes = AnyDateParser.makeMonthIndexes(Locale.ENGLISH);

    private static List<CompiledPattern> makePatterns(Locale locale) {
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        String shortMonthsRegex = Arrays.stream(dfs.getShortMonths()).filter(s -> !s.isEmpty()).map(Pattern::quote).map(s -> s + "\\.?").collect(Collectors.joining("|"));
        String longMonthsRegex = Arrays.stream(dfs.getMonths()).filter(s -> !s.isEmpty()).map(Pattern::quote).collect(Collectors.joining("|"));
        String allMonthsRegex = longMonthsRegex + "|" + shortMonthsRegex;
        String dayRegex = "(?<day>[0-9]{1,2})";
        String monthNameRegex = "(?<monthname>" + allMonthsRegex + ")";
        String monthRegex = "(?<month>[0-9]{1,2})";
        String longYearRegex = "(?<longyear>[0-9]{4,})";
        String yearRegex = "(" + longYearRegex + "|'?(?<" + GROUPNAME_SHORTYEAR + ">[0-9]{2}))";
        return Arrays.asList(new CompiledPattern(Pattern.compile(monthNameRegex + "\\s+" + dayRegex + "(th|st|nd|rd)?(\\s*,)?\\s+" + yearRegex, 2), 23), new CompiledPattern(Pattern.compile("(" + dayRegex + "\\.?\\s+)?" + monthNameRegex + "\\s+" + yearRegex, 2), 23), new CompiledPattern(Pattern.compile(longYearRegex + "-" + monthRegex + "(-" + dayRegex + ")?", 2), 25), new CompiledPattern(Pattern.compile(longYearRegex + "\\." + monthRegex + "(\\." + dayRegex + ")?", 2), 57), new CompiledPattern(Pattern.compile(longYearRegex + "-" + monthNameRegex + "(-" + dayRegex + ")?", 2), 21), new CompiledPattern(Pattern.compile("(" + dayRegex + "-)?" + monthNameRegex + "-" + yearRegex, 2), 23), new CompiledPattern(Pattern.compile(longYearRegex + "/" + monthRegex + "(/" + dayRegex + ")?", 2), 25), new CompiledPattern(Pattern.compile(monthRegex + "/" + dayRegex + "/" + yearRegex, 2), 59), new CompiledPattern(Pattern.compile(dayRegex + "/" + monthNameRegex + "/" + yearRegex, 2), 23), new CompiledPattern(Pattern.compile(dayRegex + "\\.\\s*" + monthRegex + "\\.\\s*" + yearRegex, 2), 59), new CompiledPattern(Pattern.compile(yearRegex, 2), 1));
    }

    private static Map<String, Long> makeMonthIndexes(Locale locale) {
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        HashMap<String, Long> monthIndexes = new HashMap<String, Long>();
        String[] longMonths = dfs.getMonths();
        for (int i = 0; i < longMonths.length; ++i) {
            String m = longMonths[i].toLowerCase(locale);
            monthIndexes.put(m, (long)i + 1L);
        }
        String[] shortMonths = dfs.getShortMonths();
        for (int i = 0; i < shortMonths.length; ++i) {
            String m = shortMonths[i].toLowerCase(locale);
            monthIndexes.put(m, (long)i + 1L);
        }
        return monthIndexes;
    }

    private static boolean dayBeforeMonth(Locale locale) {
        SimpleDateFormat fmt = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        String p = fmt.toPattern().toLowerCase(locale);
        int di = p.indexOf(100);
        int mi = p.indexOf(109);
        if (di == -1 || mi == -1) {
            return false;
        }
        return di < mi;
    }

    public static TemporalAccessor parse(String date) throws IllegalArgumentException {
        return AnyDateParser.parse(date, Locale.ENGLISH);
    }

    public static TemporalAccessor parse(String date, Locale locale) throws IllegalArgumentException {
        boolean dbm;
        Map<String, Long> monthIndexes;
        List<CompiledPattern> patterns;
        if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
            patterns = englishPatterns;
            monthIndexes = englishMonthIndexes;
            dbm = false;
        } else {
            patterns = AnyDateParser.makePatterns(locale);
            monthIndexes = AnyDateParser.makeMonthIndexes(locale);
            dbm = AnyDateParser.dayBeforeMonth(locale);
        }
        String trimmedDate = date.trim();
        for (CompiledPattern cp : patterns) {
            Long t;
            String dd;
            String mm;
            Matcher m = cp.p.matcher(trimmedDate);
            if (!m.find()) continue;
            Long year = null;
            Long month = null;
            Long day = null;
            if ((cp.groupNames & 1) == 1) {
                String ys = m.group(GROUPNAME_LONGYEAR);
                if (ys == null && (cp.groupNames & 2) == 2) {
                    ys = m.group(GROUPNAME_SHORTYEAR);
                }
                if (ys != null && (year = Long.valueOf(Long.parseLong(ys))) < 100L) {
                    year = year + 2000L;
                }
            }
            if ((cp.groupNames & 4) == 4) {
                mm = m.group(GROUPNAME_MONTHNAME).toLowerCase(locale);
                if (mm.endsWith(".")) {
                    mm = mm.substring(0, mm.length() - 1);
                }
                month = monthIndexes.get(mm);
            }
            if ((cp.groupNames & 8) == 8) {
                mm = m.group(GROUPNAME_MONTH);
                month = Long.parseLong(mm);
            }
            if ((cp.groupNames & 0x10) == 16 && (dd = m.group(GROUPNAME_DAY)) != null) {
                day = Long.parseLong(dd);
            }
            if (dbm && (cp.groupNames & 0x20) == 32) {
                t = month;
                month = day;
                day = t;
            }
            if (month != null && month > 12L && (day == null || day <= 12L)) {
                t = month;
                month = day;
                day = t;
            }
            return ParsedDate.of(year, month, day);
        }
        throw new IllegalArgumentException("Could not parse input string '" + date + "' to valid date");
    }

    private static class CompiledPattern {
        final Pattern p;
        final int groupNames;

        CompiledPattern(Pattern p, int groupNames) {
            this.p = p;
            this.groupNames = groupNames;
        }
    }
}

