/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.AbbreviationProvider;
import de.undercouch.citeproc.DefaultLocaleProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.LocaleProvider;
import de.undercouch.citeproc.SelectionMode;
import de.undercouch.citeproc.csl.CSLCitation;
import de.undercouch.citeproc.csl.CSLCitationItem;
import de.undercouch.citeproc.csl.CSLCitationItemBuilder;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.internal.GeneratedCitation;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SSort;
import de.undercouch.citeproc.csl.internal.SStyle;
import de.undercouch.citeproc.csl.internal.format.AsciiDocFormat;
import de.undercouch.citeproc.csl.internal.format.FoFormat;
import de.undercouch.citeproc.csl.internal.format.Format;
import de.undercouch.citeproc.csl.internal.format.HtmlFormat;
import de.undercouch.citeproc.csl.internal.format.MarkdownFormat;
import de.undercouch.citeproc.csl.internal.format.MarkdownPureFormat;
import de.undercouch.citeproc.csl.internal.format.TextFormat;
import de.undercouch.citeproc.csl.internal.locale.LLocale;
import de.undercouch.citeproc.helper.CSLUtils;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.Citation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSL {
    private Format outputFormat = new HtmlFormat();
    private boolean convertLinks = false;
    private final SStyle style;
    private final LLocale locale;
    private final ItemDataProvider itemDataProvider;
    private final AbbreviationProvider abbreviationProvider;
    private final Map<String, CSLItemData> registeredItems = new LinkedHashMap<String, CSLItemData>();
    private final List<CSLItemData> sortedItems = new ArrayList<CSLItemData>();
    private List<GeneratedCitation> generatedCitations = new ArrayList<GeneratedCitation>();

    public CSL(ItemDataProvider itemDataProvider, String style) throws IOException {
        this(itemDataProvider, new DefaultLocaleProvider(), null, style, null);
    }

    public CSL(ItemDataProvider itemDataProvider, String style, String lang) throws IOException {
        this(itemDataProvider, new DefaultLocaleProvider(), null, style, lang);
    }

    public CSL(ItemDataProvider itemDataProvider, LocaleProvider localeProvider, AbbreviationProvider abbreviationProvider, String style, String lang) throws IOException {
        if (!CSL.isStyle(style)) {
            style = CSL.retrieveStyle(style);
        }
        this.itemDataProvider = itemDataProvider;
        this.abbreviationProvider = abbreviationProvider;
        this.style = CSL.loadStyle(style);
        if (lang == null && (lang = this.style.getDefaultLocale()) == null) {
            lang = "en-US";
        }
        String strLocale = localeProvider.retrieveLocale(lang);
        LLocale locale = CSL.loadLocale(strLocale);
        for (LLocale l : this.style.getLocales()) {
            if (l.getLang() != null && (!l.getLang().getLanguage().equals(locale.getLang().getLanguage()) || !l.getLang().getCountry().isEmpty() && !l.getLang().getCountry().equals(locale.getLang().getCountry()))) continue;
            locale = locale.merge(l);
        }
        this.locale = locale;
    }

    public static List<String> getSupportedOutputFormats() {
        return Arrays.asList("asciidoc", "fo", "html", "markdown", "markdown-pure", "text");
    }

    private static Set<String> getAvailableFiles(String prefix, String knownName, String extension) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String name = prefix + knownName + "." + extension;
        URL knownUrl = CSL.class.getResource("/" + name);
        if (knownUrl != null && knownUrl.toString().endsWith(".jar!/" + name)) {
            URL url;
            try {
                String path = knownUrl.toString();
                url = new URL(path.substring(0, path.length() - name.length() - 2));
            }
            catch (MalformedURLException e) {
                String path = knownUrl.getPath();
                url = new URL(path.substring(0, path.length() - name.length() - 2));
            }
            try (InputStream inputStream = url.openStream();
                 ZipInputStream zip = new ZipInputStream(inputStream);){
                ZipEntry e;
                while ((e = zip.getNextEntry()) != null) {
                    if (!e.getName().endsWith("." + extension) || !prefix.isEmpty() && !e.getName().startsWith(prefix)) continue;
                    result.add(e.getName().substring(prefix.length(), e.getName().length() - 4));
                }
            }
        }
        return result;
    }

    public static Set<String> getSupportedStyles() throws IOException {
        return CSL.getAvailableFiles("", "ieee", "csl");
    }

    public static boolean supportsStyle(String style) {
        URL url;
        Object styleFileName = style;
        if (!((String)styleFileName).endsWith(".csl")) {
            styleFileName = (String)styleFileName + ".csl";
        }
        if (!((String)styleFileName).startsWith("/")) {
            styleFileName = "/" + (String)styleFileName;
        }
        return (url = CSL.class.getResource((String)styleFileName)) != null;
    }

    public static Set<String> getSupportedLocales() throws IOException {
        return CSL.getAvailableFiles("locales-", "en-US", "xml");
    }

    private static boolean isStyle(String style) {
        for (int i = 0; i < style.length(); ++i) {
            char c = style.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '<';
        }
        return false;
    }

    private static boolean canFormatBibliographies(SStyle style) {
        return style.getBibliography() != null;
    }

    public static boolean canFormatBibliographies(String style) throws IOException {
        if (!CSL.isStyle(style)) {
            style = CSL.retrieveStyle(style);
        }
        SStyle ss = CSL.loadStyle(style);
        return CSL.canFormatBibliographies(ss);
    }

    private static SStyle loadStyle(String style) throws IOException {
        Document styleDocument;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Could not create document builder", e);
        }
        try {
            styleDocument = builder.parse(new InputSource(new StringReader(style)));
        }
        catch (SAXException e) {
            throw new IOException("Could not parse style", e);
        }
        return new SStyle(styleDocument);
    }

    private static String retrieveStyle(String styleName) throws IOException {
        URL url;
        if (((String)styleName).startsWith("http://") || ((String)styleName).startsWith("https://")) {
            try {
                return CSL.retrieveStyle(((String)styleName).substring(((String)styleName).lastIndexOf(47) + 1));
            }
            catch (FileNotFoundException e) {
                url = new URL((String)styleName);
            }
        } else {
            if (!((String)styleName).endsWith(".csl")) {
                styleName = (String)styleName + ".csl";
            }
            if (!((String)styleName).startsWith("/")) {
                styleName = "/" + (String)styleName;
            }
            if ((url = CSL.class.getResource((String)styleName)) == null) {
                throw new FileNotFoundException("Could not find style in classpath: " + (String)styleName);
            }
        }
        String result = CSLUtils.readURLToString(url, "UTF-8");
        if (CSL.isDependent(result)) {
            String independentParentLink;
            try {
                independentParentLink = CSL.getIndependentParentLink(result);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new IOException("Could not load independent parent style", e);
            }
            if (independentParentLink == null) {
                throw new IOException("Dependent style does not have an independent parent");
            }
            return CSL.retrieveStyle(independentParentLink);
        }
        return result;
    }

    private static boolean isDependent(String style) {
        if (!style.trim().startsWith("<")) {
            return false;
        }
        Pattern p = Pattern.compile("rel\\s*=\\s*\"\\s*independent-parent\\s*\"");
        Matcher m = p.matcher(style);
        return m.find();
    }

    public static String getIndependentParentLink(String style) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource src = new InputSource(new StringReader(style));
        Document doc = builder.parse(src);
        NodeList links = doc.getElementsByTagName("link");
        for (int i = 0; i < links.getLength(); ++i) {
            Node hrefAttr;
            Node n = links.item(i);
            Node relAttr = n.getAttributes().getNamedItem("rel");
            if (relAttr == null || !"independent-parent".equals(relAttr.getTextContent()) || (hrefAttr = n.getAttributes().getNamedItem("href")) == null) continue;
            return hrefAttr.getTextContent();
        }
        return null;
    }

    private static LLocale loadLocale(String strLocale) throws IOException {
        Document localeDocument;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Could not create document builder", e);
        }
        try {
            localeDocument = builder.parse(new InputSource(new StringReader(strLocale)));
        }
        catch (SAXException e) {
            throw new IOException("Could not parse locale", e);
        }
        return new LLocale(localeDocument);
    }

    public void setOutputFormat(String format) {
        if ("asciidoc".equals(format)) {
            this.setOutputFormat(new AsciiDocFormat());
        } else if ("fo".equals(format)) {
            this.setOutputFormat(new FoFormat());
        } else if ("html".equals(format)) {
            this.setOutputFormat(new HtmlFormat());
        } else if ("markdown".equals(format)) {
            this.setOutputFormat(new MarkdownFormat());
        } else if ("markdown-pure".equals(format)) {
            this.setOutputFormat(new MarkdownPureFormat());
        } else if ("text".equals(format)) {
            this.setOutputFormat(new TextFormat());
        } else {
            throw new IllegalArgumentException("Unknown output format: `" + format + "'. Supported formats: `asciidoc', `fo', `html', `markdown', `markdown-pure', `text'.");
        }
    }

    public void setOutputFormat(Format outputFormat) {
        this.outputFormat = outputFormat;
        outputFormat.setConvertLinks(this.convertLinks);
    }

    public void setConvertLinks(boolean convert) {
        this.convertLinks = convert;
        this.outputFormat.setConvertLinks(convert);
    }

    private List<CSLItemData> registerItems(Collection<String> ids, Set<CSLItemData> updatedItems, boolean unsorted) {
        ArrayList<CSLItemData> result = new ArrayList<CSLItemData>();
        SSort.SortComparator comparator = null;
        for (String id : ids) {
            CSLItemData itemData = this.registeredItems.get(id);
            if (itemData != null) {
                result.add(itemData);
                continue;
            }
            itemData = this.itemDataProvider.retrieveItem(id);
            if (itemData == null) {
                throw new IllegalArgumentException("Missing citation item with ID: " + id);
            }
            if (unsorted || this.style.getBibliography() == null || this.style.getBibliography().getSort() == null) {
                itemData = new CSLItemDataBuilder(itemData).citationNumber(String.valueOf(this.registeredItems.size() + 1)).build();
                this.sortedItems.add(itemData);
            } else {
                IntStream idStream;
                int i;
                if (comparator == null) {
                    comparator = this.style.getBibliography().getSort().comparator(this.style, this.locale, this.abbreviationProvider);
                }
                i = (i = Collections.binarySearch(this.sortedItems, itemData, comparator)) < 0 ? -(i + 1) : this.sortedItems.size();
                int citationNumberDirection = comparator.getCitationNumberDirection();
                int citationNumber = citationNumberDirection > 0 ? i + 1 : this.sortedItems.size() + 1 - i;
                itemData = new CSLItemDataBuilder(itemData).citationNumber(String.valueOf(citationNumber)).build();
                this.sortedItems.add(i, itemData);
                if (citationNumberDirection > 0) {
                    idStream = IntStream.range(i + 1, this.sortedItems.size());
                } else {
                    int e = i;
                    idStream = IntStream.range(0, e).map(n -> e - 1 - n);
                }
                idStream.forEach(j -> {
                    CSLItemData item2 = this.sortedItems.get(j);
                    int citationNumber2 = citationNumberDirection > 0 ? j + 1 : this.sortedItems.size() - j;
                    item2 = new CSLItemDataBuilder(item2).citationNumber(String.valueOf(citationNumber2)).build();
                    this.sortedItems.set(j, item2);
                    this.registeredItems.put(item2.getId(), item2);
                    if (updatedItems != null) {
                        updatedItems.add(item2);
                    }
                });
            }
            this.registeredItems.put(itemData.getId(), itemData);
            result.add(itemData);
        }
        return result;
    }

    public void registerCitationItems(String ... ids) {
        this.registerCitationItems(ids, false);
    }

    public void registerCitationItems(String[] ids, boolean unsorted) {
        this.registerCitationItems(Arrays.asList(ids), unsorted);
    }

    public void registerCitationItems(Collection<String> ids) {
        this.registerCitationItems(ids, false);
    }

    public void registerCitationItems(Collection<String> ids, boolean unsorted) {
        this.registeredItems.clear();
        this.sortedItems.clear();
        this.registerItems(ids, null, unsorted);
    }

    public Collection<CSLItemData> getRegisteredItems() {
        return Collections.unmodifiableCollection(this.sortedItems);
    }

    public List<Citation> makeCitation(String ... ids) {
        return this.makeCitation(Arrays.asList(ids));
    }

    public List<Citation> makeCitation(Collection<String> ids) {
        CSLCitationItem[] items = new CSLCitationItem[ids.size()];
        int i = 0;
        for (String id : ids) {
            items[i++] = new CSLCitationItem(id);
        }
        return this.makeCitation(new CSLCitation(items));
    }

    private CSLCitation preRenderCitation(CSLCitation citation, Set<CSLItemData> updatedItems) {
        int len = citation.getCitationItems().length;
        ArrayList<String> itemIds = new ArrayList<String>(len);
        CSLCitationItem[] items = citation.getCitationItems();
        for (int i = 0; i < len; ++i) {
            CSLCitationItem item = items[i];
            itemIds.add(item.getId());
        }
        List<CSLItemData> registeredItems = this.registerItems(itemIds, updatedItems, false);
        CSLCitationItem[] preparedItems = new CSLCitationItem[len];
        for (int i = 0; i < len; ++i) {
            CSLCitationItem item = items[i];
            CSLItemData itemData = registeredItems.get(i);
            if (item.getLocator() != null) {
                itemData = new CSLItemDataBuilder(itemData).locator(item.getLocator()).build();
            }
            preparedItems[i] = new CSLCitationItemBuilder(item).itemData(itemData).build();
        }
        boolean unsorted = false;
        if (citation.getProperties() != null && citation.getProperties().getUnsorted() != null) {
            unsorted = citation.getProperties().getUnsorted();
        }
        if (!unsorted && this.style.getCitation().getSort() != null) {
            SSort.SortComparator itemComparator = this.style.getCitation().getSort().comparator(this.style, this.locale, this.abbreviationProvider);
            Arrays.sort(preparedItems, (a, b) -> itemComparator.compare(a.getItemData(), b.getItemData()));
        }
        return new CSLCitation(preparedItems, citation.getCitationID(), citation.getProperties());
    }

    private String renderCitation(CSLCitation preparedCitation) {
        RenderContext ctx = new RenderContext(this.style, this.locale, null, this.abbreviationProvider, preparedCitation, Collections.unmodifiableList(this.generatedCitations));
        this.style.getCitation().render(ctx);
        return this.outputFormat.formatCitation(ctx);
    }

    public List<Citation> makeCitation(CSLCitation citation) {
        LinkedHashSet<CSLItemData> updatedItems = new LinkedHashSet<CSLItemData>();
        CSLCitation preparedCitation = this.preRenderCitation(citation, updatedItems);
        String text = this.renderCitation(preparedCitation);
        ArrayList<Citation> result = new ArrayList<Citation>();
        if (!updatedItems.isEmpty()) {
            List<GeneratedCitation> oldGeneratedCitations = this.generatedCitations;
            this.generatedCitations = new ArrayList<GeneratedCitation>(oldGeneratedCitations.size());
            for (int i = 0; i < oldGeneratedCitations.size(); ++i) {
                GeneratedCitation gc = oldGeneratedCitations.get(i);
                boolean needsUpdate = false;
                block1: for (CSLItemData updatedItemData : updatedItems) {
                    for (CSLCitationItem item : gc.getOriginal().getCitationItems()) {
                        if (!item.getId().equals(updatedItemData.getId())) continue;
                        needsUpdate = true;
                        continue block1;
                    }
                }
                if (!needsUpdate) {
                    this.generatedCitations.add(gc);
                    continue;
                }
                CSLCitation upc = this.preRenderCitation(gc.getOriginal(), null);
                String ut = this.renderCitation(upc);
                if (ut.equals(gc.getGenerated().getText())) continue;
                Citation uc = new Citation(i, ut);
                this.generatedCitations.add(new GeneratedCitation(gc.getOriginal(), upc, uc));
                result.add(uc);
            }
        }
        Citation generatedCitation = new Citation(this.generatedCitations.size(), text);
        this.generatedCitations.add(new GeneratedCitation(citation, preparedCitation, generatedCitation));
        result.add(generatedCitation);
        return result;
    }

    public Bibliography makeBibliography() {
        return this.makeBibliography(null);
    }

    public Bibliography makeBibliography(SelectionMode mode, CSLItemData ... selection) {
        return this.makeBibliography(mode, selection, (CSLItemData[])null);
    }

    public Bibliography makeBibliography(SelectionMode mode, CSLItemData[] selection, CSLItemData[] quash) {
        return this.makeBibliography(item -> {
            boolean include = true;
            if (selection != null) {
                block0 : switch (mode) {
                    case INCLUDE: {
                        include = false;
                        for (CSLItemData s : selection) {
                            if (!CSL.itemDataEqualsAny(item, s)) continue;
                            include = true;
                            break block0;
                        }
                        break;
                    }
                    case EXCLUDE: {
                        for (CSLItemData s : selection) {
                            if (!CSL.itemDataEqualsAny(item, s)) continue;
                            include = false;
                            break block0;
                        }
                        break;
                    }
                    case SELECT: {
                        for (CSLItemData s : selection) {
                            if (CSL.itemDataEqualsAny(item, s)) continue;
                            include = false;
                            break block0;
                        }
                        break;
                    }
                }
            }
            if (include && quash != null) {
                boolean match = true;
                for (CSLItemData s : quash) {
                    if (CSL.itemDataEqualsAny(item, s)) continue;
                    match = false;
                    break;
                }
                if (match) {
                    include = false;
                }
            }
            return include;
        });
    }

    public Bibliography makeBibliography(Predicate<CSLItemData> filter) {
        List<CSLItemData> filteredItems;
        if (!CSL.canFormatBibliographies(this.style)) {
            throw new IllegalStateException("The citation style does not contain instructions to format bibliographies");
        }
        if (filter == null) {
            filteredItems = this.sortedItems;
        } else {
            filteredItems = new ArrayList<CSLItemData>();
            for (CSLItemData item : this.sortedItems) {
                if (!filter.test(item)) continue;
                filteredItems.add(item);
            }
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (int i = 0; i < filteredItems.size(); ++i) {
            CSLItemData item = filteredItems.get(i);
            RenderContext ctx = new RenderContext(this.style, this.locale, item, this.abbreviationProvider);
            this.style.getBibliography().render(ctx);
            if (ctx.getResult().isEmpty()) continue;
            entries.add(this.outputFormat.formatBibliographyEntry(ctx, i));
        }
        return this.outputFormat.makeBibliography(entries.toArray(new String[0]), this.style.getBibliography());
    }

    public void reset() {
        this.outputFormat = new HtmlFormat();
        this.convertLinks = false;
        this.registeredItems.clear();
        this.sortedItems.clear();
        this.generatedCitations.clear();
    }

    public static Bibliography makeAdhocBibliography(String style, CSLItemData ... items) throws IOException {
        return CSL.makeAdhocBibliography(style, "html", items);
    }

    public static Bibliography makeAdhocBibliography(String style, String outputFormat, CSLItemData ... items) throws IOException {
        ListItemDataProvider provider = new ListItemDataProvider(items);
        CSL csl = new CSL(provider, style);
        csl.setOutputFormat(outputFormat);
        String[] ids = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            ids[i] = items[i].getId();
        }
        csl.registerCitationItems(ids);
        return csl.makeBibliography();
    }

    public static List<Citation> makeAdhocCitation(String style, CSLItemData ... items) throws IOException {
        return CSL.makeAdhocCitation(style, "html", items);
    }

    public static List<Citation> makeAdhocCitation(String style, String outputFormat, CSLItemData ... items) throws IOException {
        ListItemDataProvider provider = new ListItemDataProvider(items);
        CSL csl = new CSL(provider, style);
        csl.setOutputFormat(outputFormat);
        String[] ids = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            ids[i] = items[i].getId();
        }
        return csl.makeCitation(ids);
    }

    private static boolean itemDataEqualsAny(CSLItemData a, CSLItemData b) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (b.getId() != null && Objects.equals(a.getId(), b.getId())) {
            return true;
        }
        if (b.getType() != null && Objects.equals((Object)a.getType(), (Object)b.getType())) {
            return true;
        }
        if (b.getCategories() != null && Arrays.equals(a.getCategories(), b.getCategories())) {
            return true;
        }
        if (b.getLanguage() != null && Objects.equals(a.getLanguage(), b.getLanguage())) {
            return true;
        }
        if (b.getJournalAbbreviation() != null && Objects.equals(a.getJournalAbbreviation(), b.getJournalAbbreviation())) {
            return true;
        }
        if (b.getShortTitle() != null && Objects.equals(a.getShortTitle(), b.getShortTitle())) {
            return true;
        }
        if (b.getAuthor() != null && Arrays.equals(a.getAuthor(), b.getAuthor())) {
            return true;
        }
        if (b.getCollectionEditor() != null && Arrays.equals(a.getCollectionEditor(), b.getCollectionEditor())) {
            return true;
        }
        if (b.getComposer() != null && Arrays.equals(a.getComposer(), b.getComposer())) {
            return true;
        }
        if (b.getContainerAuthor() != null && Arrays.equals(a.getContainerAuthor(), b.getContainerAuthor())) {
            return true;
        }
        if (b.getDirector() != null && Arrays.equals(a.getDirector(), b.getDirector())) {
            return true;
        }
        if (b.getEditor() != null && Arrays.equals(a.getEditor(), b.getEditor())) {
            return true;
        }
        if (b.getEditorialDirector() != null && Arrays.equals(a.getEditorialDirector(), b.getEditorialDirector())) {
            return true;
        }
        if (b.getInterviewer() != null && Arrays.equals(a.getInterviewer(), b.getInterviewer())) {
            return true;
        }
        if (b.getIllustrator() != null && Arrays.equals(a.getIllustrator(), b.getIllustrator())) {
            return true;
        }
        if (b.getOriginalAuthor() != null && Arrays.equals(a.getOriginalAuthor(), b.getOriginalAuthor())) {
            return true;
        }
        if (b.getRecipient() != null && Arrays.equals(a.getRecipient(), b.getRecipient())) {
            return true;
        }
        if (b.getReviewedAuthor() != null && Arrays.equals(a.getReviewedAuthor(), b.getReviewedAuthor())) {
            return true;
        }
        if (b.getTranslator() != null && Arrays.equals(a.getTranslator(), b.getTranslator())) {
            return true;
        }
        if (b.getAccessed() != null && Objects.equals(a.getAccessed(), b.getAccessed())) {
            return true;
        }
        if (b.getContainer() != null && Objects.equals(a.getContainer(), b.getContainer())) {
            return true;
        }
        if (b.getEventDate() != null && Objects.equals(a.getEventDate(), b.getEventDate())) {
            return true;
        }
        if (b.getIssued() != null && Objects.equals(a.getIssued(), b.getIssued())) {
            return true;
        }
        if (b.getOriginalDate() != null && Objects.equals(a.getOriginalDate(), b.getOriginalDate())) {
            return true;
        }
        if (b.getSubmitted() != null && Objects.equals(a.getSubmitted(), b.getSubmitted())) {
            return true;
        }
        if (b.getAbstrct() != null && Objects.equals(a.getAbstrct(), b.getAbstrct())) {
            return true;
        }
        if (b.getAnnote() != null && Objects.equals(a.getAnnote(), b.getAnnote())) {
            return true;
        }
        if (b.getArchive() != null && Objects.equals(a.getArchive(), b.getArchive())) {
            return true;
        }
        if (b.getArchiveLocation() != null && Objects.equals(a.getArchiveLocation(), b.getArchiveLocation())) {
            return true;
        }
        if (b.getArchivePlace() != null && Objects.equals(a.getArchivePlace(), b.getArchivePlace())) {
            return true;
        }
        if (b.getAuthority() != null && Objects.equals(a.getAuthority(), b.getAuthority())) {
            return true;
        }
        if (b.getCallNumber() != null && Objects.equals(a.getCallNumber(), b.getCallNumber())) {
            return true;
        }
        if (b.getChapterNumber() != null && Objects.equals(a.getChapterNumber(), b.getChapterNumber())) {
            return true;
        }
        if (b.getCitationNumber() != null && Objects.equals(a.getCitationNumber(), b.getCitationNumber())) {
            return true;
        }
        if (b.getCitationLabel() != null && Objects.equals(a.getCitationLabel(), b.getCitationLabel())) {
            return true;
        }
        if (b.getCollectionNumber() != null && Objects.equals(a.getCollectionNumber(), b.getCollectionNumber())) {
            return true;
        }
        if (b.getCollectionTitle() != null && Objects.equals(a.getCollectionTitle(), b.getCollectionTitle())) {
            return true;
        }
        if (b.getContainerTitle() != null && Objects.equals(a.getContainerTitle(), b.getContainerTitle())) {
            return true;
        }
        if (b.getContainerTitleShort() != null && Objects.equals(a.getContainerTitleShort(), b.getContainerTitleShort())) {
            return true;
        }
        if (b.getDimensions() != null && Objects.equals(a.getDimensions(), b.getDimensions())) {
            return true;
        }
        if (b.getDOI() != null && Objects.equals(a.getDOI(), b.getDOI())) {
            return true;
        }
        if (b.getEdition() != null && Objects.equals(a.getEdition(), b.getEdition())) {
            return true;
        }
        if (b.getEvent() != null && Objects.equals(a.getEvent(), b.getEvent())) {
            return true;
        }
        if (b.getEventPlace() != null && Objects.equals(a.getEventPlace(), b.getEventPlace())) {
            return true;
        }
        if (b.getFirstReferenceNoteNumber() != null && Objects.equals(a.getFirstReferenceNoteNumber(), b.getFirstReferenceNoteNumber())) {
            return true;
        }
        if (b.getGenre() != null && Objects.equals(a.getGenre(), b.getGenre())) {
            return true;
        }
        if (b.getISBN() != null && Objects.equals(a.getISBN(), b.getISBN())) {
            return true;
        }
        if (b.getISSN() != null && Objects.equals(a.getISSN(), b.getISSN())) {
            return true;
        }
        if (b.getIssue() != null && Objects.equals(a.getIssue(), b.getIssue())) {
            return true;
        }
        if (b.getJurisdiction() != null && Objects.equals(a.getJurisdiction(), b.getJurisdiction())) {
            return true;
        }
        if (b.getKeyword() != null && Objects.equals(a.getKeyword(), b.getKeyword())) {
            return true;
        }
        if (b.getLocator() != null && Objects.equals(a.getLocator(), b.getLocator())) {
            return true;
        }
        if (b.getMedium() != null && Objects.equals(a.getMedium(), b.getMedium())) {
            return true;
        }
        if (b.getNote() != null && Objects.equals(a.getNote(), b.getNote())) {
            return true;
        }
        if (b.getNumber() != null && Objects.equals(a.getNumber(), b.getNumber())) {
            return true;
        }
        if (b.getNumberOfPages() != null && Objects.equals(a.getNumberOfPages(), b.getNumberOfPages())) {
            return true;
        }
        if (b.getNumberOfVolumes() != null && Objects.equals(a.getNumberOfVolumes(), b.getNumberOfVolumes())) {
            return true;
        }
        if (b.getOriginalPublisher() != null && Objects.equals(a.getOriginalPublisher(), b.getOriginalPublisher())) {
            return true;
        }
        if (b.getOriginalPublisherPlace() != null && Objects.equals(a.getOriginalPublisherPlace(), b.getOriginalPublisherPlace())) {
            return true;
        }
        if (b.getOriginalTitle() != null && Objects.equals(a.getOriginalTitle(), b.getOriginalTitle())) {
            return true;
        }
        if (b.getPage() != null && Objects.equals(a.getPage(), b.getPage())) {
            return true;
        }
        if (b.getPMCID() != null && Objects.equals(a.getPMCID(), b.getPMCID())) {
            return true;
        }
        if (b.getPMID() != null && Objects.equals(a.getPMID(), b.getPMID())) {
            return true;
        }
        if (b.getPublisher() != null && Objects.equals(a.getPublisher(), b.getPublisher())) {
            return true;
        }
        if (b.getPublisherPlace() != null && Objects.equals(a.getPublisherPlace(), b.getPublisherPlace())) {
            return true;
        }
        if (b.getReferences() != null && Objects.equals(a.getReferences(), b.getReferences())) {
            return true;
        }
        if (b.getReviewedTitle() != null && Objects.equals(a.getReviewedTitle(), b.getReviewedTitle())) {
            return true;
        }
        if (b.getScale() != null && Objects.equals(a.getScale(), b.getScale())) {
            return true;
        }
        if (b.getSection() != null && Objects.equals(a.getSection(), b.getSection())) {
            return true;
        }
        if (b.getSource() != null && Objects.equals(a.getSource(), b.getSource())) {
            return true;
        }
        if (b.getStatus() != null && Objects.equals(a.getStatus(), b.getStatus())) {
            return true;
        }
        if (b.getTitle() != null && Objects.equals(a.getTitle(), b.getTitle())) {
            return true;
        }
        if (b.getTitleShort() != null && Objects.equals(a.getTitleShort(), b.getTitleShort())) {
            return true;
        }
        if (b.getURL() != null && Objects.equals(a.getURL(), b.getURL())) {
            return true;
        }
        if (b.getVersion() != null && Objects.equals(a.getVersion(), b.getVersion())) {
            return true;
        }
        if (b.getVolume() != null && Objects.equals(a.getVolume(), b.getVolume())) {
            return true;
        }
        return b.getYearSuffix() != null && Objects.equals(a.getYearSuffix(), b.getYearSuffix());
    }
}

