/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.behavior;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.behavior.Behavior;
import de.undercouch.citeproc.csl.internal.token.TextToken;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.function.Consumer;
import org.w3c.dom.Node;

public class Quotes
implements Behavior {
    private final boolean quotes;

    public Quotes(Node node) {
        this.quotes = Boolean.parseBoolean(NodeHelper.getAttrValue(node, "quotes"));
    }

    @Override
    public void accept(Consumer<RenderContext> renderFunction, RenderContext ctx) {
        if (this.quotes) {
            RenderContext tmp = new RenderContext(ctx);
            renderFunction.accept(tmp);
            if (!tmp.getResult().isEmpty()) {
                String openQuote = ctx.getTerm("open-quote");
                ctx.emit(openQuote, TextToken.Type.OPEN_QUOTE);
                ctx.emit(tmp.getResult());
                String closeQuote = ctx.getTerm("close-quote");
                ctx.emit(closeQuote, TextToken.Type.CLOSE_QUOTE);
            }
        } else {
            renderFunction.accept(ctx);
        }
    }
}

