/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.format.MarkdownPureFormat;
import de.undercouch.citeproc.csl.internal.token.DisplayGroupToken;

public class MarkdownFormat
extends MarkdownPureFormat {
    @Override
    public String getName() {
        return "markdown";
    }

    @Override
    protected String doFormatBibliographyEntry(TokenBuffer buffer, RenderContext ctx, int index) {
        Object r = this.format(buffer);
        if (!buffer.isEmpty()) {
            r = (String)r + "<br />\n";
        }
        return r;
    }

    @Override
    protected String openFontStyle(int fontStyle) {
        if (fontStyle == 2) {
            return "*";
        }
        return "<span style=\"font-style: oblique\">";
    }

    @Override
    protected String closeFontStyle(int fontStyle) {
        if (fontStyle == 2) {
            return "*";
        }
        return "</span>";
    }

    @Override
    protected String openFontVariant(int fontVariant) {
        return "<span style=\"font-variant: small-caps\">";
    }

    @Override
    protected String closeFontVariant(int fontVariant) {
        return "</span>";
    }

    @Override
    protected String openFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "**";
        }
        return "<span style=\"font-weight: 100\">";
    }

    @Override
    protected String closeFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "**";
        }
        return "</span>";
    }

    @Override
    protected String openTextDecoration(int textDecoration) {
        return "<span style=\"text-decoration: underline\">";
    }

    @Override
    protected String closeTextDecoration(int textDecoration) {
        return "</span>";
    }

    @Override
    protected String openVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "<sup>";
        }
        return "<sub>";
    }

    @Override
    protected String closeVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "</sup>";
        }
        return "</sub>";
    }

    @Override
    protected String openDisplayGroup(DisplayGroupToken.Type type) {
        switch (type) {
            case BLOCK: 
            case INDENT: {
                return "<br />";
            }
        }
        return null;
    }
}

