/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SBibliography;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.format.BaseFormat;
import de.undercouch.citeproc.csl.internal.token.DisplayGroupToken;
import de.undercouch.citeproc.csl.internal.token.TextToken;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.SecondFieldAlign;

public class MarkdownPureFormat
extends BaseFormat {
    @Override
    public String getName() {
        return "markdown-pure";
    }

    @Override
    protected String doFormatCitation(TokenBuffer buffer, RenderContext ctx) {
        return this.format(buffer);
    }

    @Override
    protected String doFormatBibliographyEntry(TokenBuffer buffer, RenderContext ctx, int index) {
        if (!buffer.isEmpty()) {
            buffer.append("\n\n", TextToken.Type.TEXT);
        }
        return this.format(buffer);
    }

    @Override
    protected String formatURL(String str) {
        return this.doFormatLink(str, str);
    }

    @Override
    protected String formatDOI(String str) {
        String uri = this.addDOIPrefix(str);
        return this.doFormatLink(str, uri);
    }

    @Override
    protected String doFormatLink(String text, String uri) {
        text = text.replace("[", "\\[").replace("]", "\\]");
        uri = uri.replace("<", "\\<").replace(">", "\\>");
        return "[" + text + "](<" + uri + ">)";
    }

    @Override
    protected String escape(String str) {
        return str.replaceAll("[!\"#$%&'()*+,-./:;<=>?@\\[\\\\\\]^_`{|}~]", "\\\\$0");
    }

    @Override
    public Bibliography makeBibliography(String[] entries, SBibliography bibliographyElement) {
        SecondFieldAlign sfa = bibliographyElement.getSecondFieldAlign();
        return new Bibliography(entries, null, null, null, null, null, null, null, null, sfa);
    }

    @Override
    protected String openFontStyle(int fontStyle) {
        return "*";
    }

    @Override
    protected String closeFontStyle(int fontStyle) {
        return "*";
    }

    @Override
    protected String openFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "**";
        }
        return null;
    }

    @Override
    protected String closeFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "**";
        }
        return null;
    }

    @Override
    protected String openDisplayGroup(DisplayGroupToken.Type type) {
        switch (type) {
            case BLOCK: 
            case INDENT: {
                return "\n";
            }
        }
        return null;
    }
}

