/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.csl.internal.rendering.condition.SCondition;
import de.undercouch.citeproc.csl.internal.rendering.condition.SElse;
import de.undercouch.citeproc.csl.internal.rendering.condition.SIf;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SChoose {
    private final List<SCondition> conditions = new ArrayList<SCondition>();

    public SChoose(Node node) {
        NodeList children = node.getChildNodes();
        boolean done = false;
        for (int i = 0; i < children.getLength(); ++i) {
            SCondition condition;
            String nodeName;
            Node c = children.item(i);
            if (c.getNodeType() != 1) continue;
            switch (nodeName = c.getNodeName()) {
                case "if": {
                    if (!this.conditions.isEmpty()) {
                        throw new IllegalStateException("Multiple `if' nodes found");
                    }
                    condition = new SIf(c);
                    break;
                }
                case "else-if": {
                    if (this.conditions.isEmpty()) {
                        throw new IllegalStateException("`else-if' without `if' found");
                    }
                    if (done) {
                        throw new IllegalStateException("`else-if' following `else' found");
                    }
                    condition = new SIf(c);
                    break;
                }
                case "else": {
                    if (done) {
                        throw new IllegalStateException("Multiple `else' nodes found");
                    }
                    condition = new SElse(c);
                    done = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown conditional element: " + nodeName);
                }
            }
            this.conditions.add(condition);
        }
    }

    public List<SRenderingElement> evaluate(RenderContext ctx) {
        ArrayList<SRenderingElement> result = new ArrayList<SRenderingElement>();
        for (SCondition c : this.conditions) {
            if (!c.matches(ctx)) continue;
            result.addAll(c.getElements(ctx));
            break;
        }
        return result;
    }
}

