/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download;

import de.undercouch.gradle.tasks.download.DownloadSpec;
import de.undercouch.gradle.tasks.download.internal.InsecureHostnameVerifier;
import de.undercouch.gradle.tasks.download.internal.InsecureTrustManager;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.tools.ant.util.Base64Converter;
import org.gradle.api.Project;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class DownloadAction
implements DownloadSpec {
    private static final int MAX_NUMBER_OF_REDIRECTS = 30;
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private final Project project;
    private List<URL> sources = new ArrayList<URL>(1);
    private File dest;
    private boolean quiet = false;
    private boolean overwrite = true;
    private boolean onlyIfNewer = false;
    private boolean compress = true;
    private String username;
    private String password;
    private Map<String, String> headers;
    private boolean acceptAnyCertificate = false;
    private ProgressLogger progressLogger;
    private String size;
    private long processedBytes = 0L;
    private long loggedKb = 0L;
    private int skipped = 0;
    private SSLSocketFactory insecureSSLSocketFactory = null;

    public DownloadAction(Project project) {
        this.project = project;
    }

    public void execute() throws IOException {
        if (this.sources == null || this.sources.isEmpty()) {
            throw new IllegalArgumentException("Please provide a download source");
        }
        if (this.dest == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        if (this.dest.equals(this.project.getBuildDir())) {
            this.dest.mkdirs();
        }
        if (this.sources.size() > 1 && !this.dest.isDirectory()) {
            throw new IllegalArgumentException("If multiple sources are provided the destination has to be a directory.");
        }
        for (URL src : this.sources) {
            this.execute(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(URL src) throws IOException {
        URLConnection conn;
        File destFile = this.dest;
        if (destFile.isDirectory()) {
            String name = src.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            destFile = new File(this.dest, name);
        } else {
            File parent = destFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
        }
        if (!this.overwrite && destFile.exists()) {
            if (!this.quiet) {
                this.project.getLogger().info("Destination file already exists. Skipping '" + destFile.getName() + "'");
            }
            ++this.skipped;
            return;
        }
        long timestamp = 0L;
        if (this.onlyIfNewer && destFile.exists()) {
            timestamp = destFile.lastModified();
        }
        if (!this.quiet) {
            try {
                Method getServices = this.project.getClass().getMethod("getServices", new Class[0]);
                Object serviceFactory = getServices.invoke((Object)this.project, new Object[0]);
                Method get = serviceFactory.getClass().getMethod("get", Class.class);
                Object progressLoggerFactory = get.invoke(serviceFactory, ProgressLoggerFactory.class);
                Method newOperation = progressLoggerFactory.getClass().getMethod("newOperation", Class.class);
                this.progressLogger = (ProgressLogger)newOperation.invoke(progressLoggerFactory, this.getClass());
                String desc = "Download " + src.toString();
                Method setDescription = this.progressLogger.getClass().getMethod("setDescription", String.class);
                setDescription.setAccessible(true);
                setDescription.invoke((Object)this.progressLogger, desc);
                Method setLoggingHeader = this.progressLogger.getClass().getMethod("setLoggingHeader", String.class);
                setLoggingHeader.setAccessible(true);
                setLoggingHeader.invoke((Object)this.progressLogger, desc);
            }
            catch (Exception e) {
                this.project.getLogger().error("Unable to get progress logger. Download progress will not be displayed.");
            }
        }
        if ((conn = this.openConnection(src, timestamp)) == null) {
            return;
        }
        long contentLength = this.parseContentLength(conn);
        if (contentLength >= 0L) {
            this.size = this.toLengthText(contentLength);
        }
        this.processedBytes = 0L;
        this.loggedKb = 0L;
        InputStream is = conn.getInputStream();
        if (this.isContentCompressed(conn)) {
            is = new GZIPInputStream(is);
        }
        try {
            this.startProgress();
            FileOutputStream os = new FileOutputStream(destFile);
            boolean finished = false;
            try {
                int read;
                byte[] buf = new byte[10240];
                while ((read = is.read(buf)) >= 0) {
                    ((OutputStream)os).write(buf, 0, read);
                    this.processedBytes += (long)read;
                    this.logProgress();
                }
                os.flush();
                finished = true;
            }
            finally {
                ((OutputStream)os).close();
                if (!finished) {
                    destFile.delete();
                }
            }
        }
        finally {
            is.close();
            this.completeProgress();
        }
        long newTimestamp = conn.getLastModified();
        if (this.onlyIfNewer && newTimestamp > 0L) {
            destFile.setLastModified(newTimestamp);
        }
    }

    private URLConnection openConnection(URL src, long timestamp) throws IOException {
        int redirects = 30;
        URLConnection uc = src.openConnection();
        while (true) {
            HttpURLConnection httpConnection;
            if (uc instanceof HttpURLConnection) {
                httpConnection = (HttpURLConnection)uc;
                httpConnection.setInstanceFollowRedirects(true);
            }
            if (uc instanceof HttpsURLConnection && this.acceptAnyCertificate) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)uc;
                httpsConnection.setSSLSocketFactory(this.getInsecureSSLSocketFactory());
                httpsConnection.setHostnameVerifier(INSECURE_HOSTNAME_VERIFIER);
            }
            if (timestamp > 0L) {
                uc.setIfModifiedSince(timestamp);
            }
            if (this.username != null && this.password != null) {
                String up = this.username + ":" + this.password;
                Base64Converter encoder = new Base64Converter();
                String encoding = encoder.encode(up.getBytes());
                uc.setRequestProperty("Authorization", "Basic " + encoding);
            }
            if (this.headers != null) {
                for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                    uc.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
                }
            }
            if (this.compress) {
                uc.setRequestProperty("Accept-Encoding", "gzip");
            }
            uc.connect();
            if (!(uc instanceof HttpURLConnection)) break;
            httpConnection = (HttpURLConnection)uc;
            int responseCode = httpConnection.getResponseCode();
            long lastModified = httpConnection.getLastModified();
            if (responseCode == 304 || lastModified != 0L && timestamp >= lastModified) {
                if (!this.quiet) {
                    this.project.getLogger().info("Not modified. Skipping '" + src + "'");
                }
                ++this.skipped;
                return null;
            }
            if (responseCode != 302 && responseCode != 301 && responseCode != 303) break;
            if (redirects == 0) {
                throw new IllegalStateException("Request exceeds maximum number of redirects (30)");
            }
            String nu = uc.getHeaderField("Location");
            String cookie = uc.getHeaderField("Set-Cookie");
            uc = (HttpURLConnection)new URL(nu).openConnection();
            uc.setRequestProperty("Cookie", cookie);
            --redirects;
        }
        return uc;
    }

    private String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    private long parseContentLength(URLConnection conn) {
        String value = conn.getHeaderField("Content-Length");
        if (value == null || value.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private boolean isContentCompressed(URLConnection conn) {
        String value = conn.getHeaderField("Content-Encoding");
        if (value == null || value.isEmpty()) {
            return false;
        }
        return value.equalsIgnoreCase("gzip");
    }

    private void startProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.started();
        }
    }

    private void completeProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.completed();
        }
    }

    private void logProgress() {
        if (this.progressLogger == null) {
            return;
        }
        long processedKb = this.processedBytes / 1024L;
        if (processedKb > this.loggedKb) {
            String msg = this.toLengthText(this.processedBytes);
            if (this.size != null) {
                msg = msg + "/" + this.size;
            }
            msg = msg + " downloaded";
            this.progressLogger.progress(msg);
            this.loggedKb = processedKb;
        }
    }

    boolean isSkipped() {
        return this.sources != null && this.skipped == this.sources.size();
    }

    @Override
    public void src(Object src) throws MalformedURLException {
        if (this.sources == null) {
            this.sources = new ArrayList<URL>(1);
        }
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if (src instanceof CharSequence) {
            this.sources.add(new URL(src.toString()));
        } else if (src instanceof URL) {
            this.sources.add((URL)src);
        } else if (src instanceof Collection) {
            Collection sc = (Collection)src;
            for (Object sco : sc) {
                this.src(sco);
            }
        } else if (src != null && src.getClass().isArray()) {
            int len = Array.getLength(src);
            for (int i = 0; i < len; ++i) {
                Object sco = Array.get(src, i);
                this.src(sco);
            }
        } else {
            throw new IllegalArgumentException("Download source must either be a URL, a CharSequence, a Collection or an array.");
        }
    }

    @Override
    public void dest(Object dest) {
        if (dest instanceof Closure) {
            Closure closure = (Closure)dest;
            dest = closure.call();
        }
        if (dest instanceof CharSequence) {
            this.dest = this.project.file((Object)dest.toString());
        } else if (dest instanceof File) {
            this.dest = (File)dest;
        } else {
            throw new IllegalArgumentException("Download destination must either be a File or a CharSequence");
        }
    }

    @Override
    public void quiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.onlyIfNewer = onlyIfNewer;
    }

    @Override
    public void compress(boolean compress) {
        this.compress = compress;
    }

    @Override
    public void username(String username) {
        this.username = username;
    }

    @Override
    public void password(String password) {
        this.password = password;
    }

    @Override
    public void headers(Map<String, String> headers) {
        if (headers == null) {
            headers = new LinkedHashMap<String, String>();
        }
        this.headers.putAll(headers);
    }

    @Override
    public void header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.acceptAnyCertificate = accept;
    }

    @Override
    public Object getSrc() {
        if (this.sources != null && this.sources.size() == 1) {
            return this.sources.get(0);
        }
        return this.sources;
    }

    @Override
    public File getDest() {
        return this.dest;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.onlyIfNewer;
    }

    @Override
    public boolean isCompress() {
        return this.compress;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    private SSLSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = sc.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }
}

