/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download;

import de.undercouch.gradle.tasks.download.DownloadAction;
import de.undercouch.gradle.tasks.download.DownloadSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.Credentials;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public class Download
extends DefaultTask
implements DownloadSpec {
    private final DownloadAction action = new DownloadAction(this.getProject());

    public Download() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !Download.this.isOnlyIfModified() && !Download.this.isOverwrite();
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                if (Download.this.getProject().getGradle().getStartParameter().isOffline()) {
                    for (File f : Download.this.getOutputFiles()) {
                        if (f.exists()) {
                            if (Download.this.isQuiet()) continue;
                            Download.this.getProject().getLogger().info("Skipping existing file '" + f.getName() + "' in offline mode.");
                            continue;
                        }
                        throw new IllegalStateException("Unable to download file '" + f.getName() + "' in offline mode.");
                    }
                    return false;
                }
                return true;
            }
        });
    }

    @TaskAction
    public void download() throws IOException {
        this.action.execute();
        try {
            if (this.action.isUpToDate()) {
                Method getState = this.getClass().getMethod("getState", new Class[0]);
                Object state = getState.invoke((Object)this, new Object[0]);
                try {
                    Method upToDate = state.getClass().getMethod("upToDate", new Class[0]);
                    upToDate.invoke(state, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    this.setUpToDate(state);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setUpToDate(Object state) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> TaskExecutionOutcome = Class.forName("org.gradle.api.internal.tasks.TaskExecutionOutcome");
        Method valueOf = TaskExecutionOutcome.getMethod("valueOf", String.class);
        Object UP_TO_DATE = valueOf.invoke(null, "UP_TO_DATE");
        Method setOutcome = state.getClass().getMethod("setOutcome", TaskExecutionOutcome);
        setOutcome.invoke(state, UP_TO_DATE);
        Method setDidWork = state.getClass().getMethod("setDidWork", Boolean.TYPE);
        setDidWork.invoke(state, false);
    }

    @OutputFiles
    public List<File> getOutputFiles() {
        return this.action.getOutputFiles();
    }

    @Override
    public void src(Object src) throws MalformedURLException {
        this.action.src(src);
    }

    @Override
    public void dest(Object dest) {
        this.action.dest(dest);
    }

    @Override
    public void quiet(boolean quiet) {
        this.action.quiet(quiet);
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.action.overwrite(overwrite);
    }

    @Override
    public void onlyIfModified(boolean onlyIfModified) {
        this.action.onlyIfModified(onlyIfModified);
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.action.onlyIfNewer(onlyIfNewer);
    }

    @Override
    public void compress(boolean compress) {
        this.action.compress(compress);
    }

    @Override
    public void username(String username) {
        this.action.username(username);
    }

    @Override
    public void password(String password) {
        this.action.password(password);
    }

    @Override
    public void authScheme(Object authScheme) {
        this.action.authScheme(authScheme);
    }

    @Override
    public void credentials(Credentials credentials) {
        this.action.credentials(credentials);
    }

    @Override
    public void headers(Map<String, String> headers) {
        this.action.headers(headers);
    }

    @Override
    public void header(String name, String value) {
        this.action.header(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.action.acceptAnyCertificate(accept);
    }

    @Override
    public void timeout(int milliseconds) {
        this.action.timeout(milliseconds);
    }

    @Override
    public void requestInterceptor(HttpRequestInterceptor interceptor) {
        this.action.requestInterceptor(interceptor);
    }

    @Override
    public void responseInterceptor(HttpResponseInterceptor interceptor) {
        this.action.responseInterceptor(interceptor);
    }

    @Override
    public Object getSrc() {
        return this.action.getSrc();
    }

    @Override
    public File getDest() {
        return this.action.getDest();
    }

    @Override
    public boolean isQuiet() {
        return this.action.isQuiet();
    }

    @Override
    public boolean isOverwrite() {
        return this.action.isOverwrite();
    }

    @Override
    public boolean isOnlyIfModified() {
        return this.action.isOnlyIfModified();
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.action.isOnlyIfNewer();
    }

    @Override
    public boolean isCompress() {
        return this.action.isCompress();
    }

    @Override
    public String getUsername() {
        return this.action.getUsername();
    }

    @Override
    public String getPassword() {
        return this.action.getPassword();
    }

    @Override
    public AuthScheme getAuthScheme() {
        return this.action.getAuthScheme();
    }

    @Override
    public Credentials getCredentials() {
        return this.action.getCredentials();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.action.getHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.action.getHeader(name);
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.action.isAcceptAnyCertificate();
    }

    @Override
    public int getTimeout() {
        return this.action.getTimeout();
    }

    @Override
    public HttpRequestInterceptor getRequestInterceptor() {
        return this.action.getRequestInterceptor();
    }

    @Override
    public HttpResponseInterceptor getResponseInterceptor() {
        return this.action.getResponseInterceptor();
    }
}

