/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.http.client.protocol;

import de.undercouch.gradle.tasks.download.org.apache.http.HttpEntity;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpEntityEnclosingRequest;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpRequest;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpRequestInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.http.HttpVersion;
import de.undercouch.gradle.tasks.download.org.apache.http.ProtocolVersion;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import de.undercouch.gradle.tasks.download.org.apache.http.client.config.RequestConfig;
import de.undercouch.gradle.tasks.download.org.apache.http.client.protocol.HttpClientContext;
import de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;
import de.undercouch.gradle.tasks.download.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

