/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.ssl;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.ssl.FixedPortStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.ssl.SecurePortStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.ssl.H2TlsSupport;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.ssl.SSLContexts;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;

public class H2ServerTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SecurePortStrategy securePortStrategy;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    @Deprecated
    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.securePortStrategy = securePortStrategy;
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    @Deprecated
    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, securePortStrategy, null, initializer, verifier);
    }

    @Deprecated
    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy, SSLSessionVerifier verifier) {
        this(sslContext, securePortStrategy, null, null, verifier);
    }

    @Deprecated
    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy) {
        this(sslContext, securePortStrategy, null, null, null);
    }

    @Deprecated
    public H2ServerTlsStrategy(int ... securePorts) {
        this(SSLContexts.createSystemDefault(), new FixedPortStrategy(securePorts));
    }

    public H2ServerTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
        this.securePortStrategy = null;
    }

    public H2ServerTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, (SSLBufferMode)null, initializer, verifier);
    }

    public H2ServerTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, (SSLBufferMode)null, null, verifier);
    }

    public H2ServerTlsStrategy(SSLContext sslContext) {
        this(sslContext, (SSLBufferMode)null, null, null);
    }

    public H2ServerTlsStrategy() {
        this(SSLContexts.createSystemDefault());
    }

    private boolean isApplicable(SocketAddress localAddress) {
        return this.securePortStrategy == null || this.securePortStrategy.isSecure(localAddress);
    }

    @Override
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        if (this.isApplicable(localAddress)) {
            tlsSession.startTls(this.sslContext, host, this.sslBufferMode, H2TlsSupport.enforceRequirements(attachment, this.initializer), this.verifier, handshakeTimeout);
            return true;
        }
        return false;
    }
}

