/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.bootstrap;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.function.Callback;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.function.Decorator;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.function.Supplier;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.config.CharCodingConfig;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpProcessor;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.UriPatternType;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.config.H2Config;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.H2Processors;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.H2OnlyClientProtocolNegotiator;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.bootstrap.H2MultiplexingRequester;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.bootstrap.HandlerEntry;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.ssl.H2ClientTlsStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOEventHandler;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOReactorConfig;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOSession;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOSessionListener;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ProtocolIOSession;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;
import java.util.ArrayList;
import java.util.List;

public class H2MultiplexingRequesterBootstrap {
    private final List<HandlerEntry<Supplier<AsyncPushConsumer>>> pushConsumerList = new ArrayList<HandlerEntry<Supplier<AsyncPushConsumer>>>();
    private UriPatternType uriPatternType;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private H2Config h2Config;
    private TlsStrategy tlsStrategy;
    private boolean strictALPNHandshake;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private H2StreamListener streamListener;

    private H2MultiplexingRequesterBootstrap() {
    }

    public static H2MultiplexingRequesterBootstrap bootstrap() {
        return new H2MultiplexingRequesterBootstrap();
    }

    public final H2MultiplexingRequesterBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setStrictALPNHandshake(boolean strictALPNHandshake) {
        this.strictALPNHandshake = strictALPNHandshake;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setStreamListener(H2StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setUriPatternType(UriPatternType uriPatternType) {
        this.uriPatternType = uriPatternType;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.pushConsumerList.add(new HandlerEntry<Supplier<AsyncPushConsumer>>(null, uriPattern, supplier));
        return this;
    }

    public final H2MultiplexingRequesterBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.pushConsumerList.add(new HandlerEntry<Supplier<AsyncPushConsumer>>(hostname, uriPattern, supplier));
        return this;
    }

    public H2MultiplexingRequester create() {
        RequestHandlerRegistry<Supplier<AsyncPushConsumer>> registry = new RequestHandlerRegistry<Supplier<AsyncPushConsumer>>(this.uriPatternType);
        for (HandlerEntry<Supplier<AsyncPushConsumer>> entry : this.pushConsumerList) {
            registry.register(entry.hostname, entry.uriPattern, (Supplier<AsyncPushConsumer>)entry.handler);
        }
        final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.client(), new DefaultAsyncPushConsumerFactory(registry), this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.streamListener);
        return new H2MultiplexingRequester(this.ioReactorConfig, new IOEventHandlerFactory(){

            @Override
            public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
                return new H2OnlyClientProtocolNegotiator(ioSession, http2StreamHandlerFactory, H2MultiplexingRequesterBootstrap.this.strictALPNHandshake);
            }
        }, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, DefaultAddressResolver.INSTANCE, this.tlsStrategy != null ? this.tlsStrategy : new H2ClientTlsStrategy());
    }
}

