/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic;

import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.HttpRoute;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.UserTokenHandler;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.classic.ExecChain;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.classic.ExecChainHandler;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.classic.ExecRuntime;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.ConnectionShutdownException;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.protocol.HttpClientContext;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.Contract;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.Internal;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.ThreadingBehavior;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ClassicHttpRequest;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ClassicHttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ConnectionReuseStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpEntity;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpException;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.message.RequestLine;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.io.CloseMode;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.TimeValue;
import de.undercouch.gradle.tasks.download.org.slf4j.Logger;
import de.undercouch.gradle.tasks.download.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class MainClientExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MainClientExec.class);
    private final HttpClientConnectionManager connectionManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final UserTokenHandler userTokenHandler;

    public MainClientExec(HttpClientConnectionManager connectionManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, UserTokenHandler userTokenHandler) {
        this.connectionManager = Args.notNull(connectionManager, "Connection manager");
        this.reuseStrategy = Args.notNull(reuseStrategy, "Connection reuse strategy");
        this.keepAliveStrategy = Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.userTokenHandler = Args.notNull(userTokenHandler, "User token handler");
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ExecRuntime execRuntime = scope.execRuntime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} executing {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        try {
            ClassicHttpResponse response = execRuntime.execute(exchangeId, request, context);
            Object userToken = context.getUserToken();
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, context);
                context.setAttribute("http.user-token", userToken);
            }
            if (this.reuseStrategy.keepAlive(request, response, context)) {
                TimeValue duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                if (LOG.isDebugEnabled()) {
                    String s = duration != null ? "for " + duration : "indefinitely";
                    LOG.debug("{} connection can be kept alive {}", (Object)exchangeId, (Object)s);
                }
                execRuntime.markConnectionReusable(userToken, duration);
            } else {
                execRuntime.markConnectionNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                execRuntime.releaseEndpoint();
                return new CloseableHttpResponse(response, null);
            }
            return new CloseableHttpResponse(response, execRuntime);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            execRuntime.discardEndpoint();
            throw ioex;
        }
        catch (HttpException | IOException | RuntimeException ex) {
            execRuntime.discardEndpoint();
            throw ex;
        }
        catch (Error error) {
            this.connectionManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }
}

