/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.internal.CustomHttpRequestRetryStrategy;
import de.undercouch.gradle.tasks.download.internal.DebugInterceptor;
import de.undercouch.gradle.tasks.download.internal.HttpClientFactory;
import de.undercouch.gradle.tasks.download.internal.InsecureHostnameVerifier;
import de.undercouch.gradle.tasks.download.internal.InsecureTrustManager;
import de.undercouch.gradle.tasks.download.internal.StripPortsFromHostInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.config.ConnectionConfig;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.config.Registry;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.config.RegistryBuilder;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.TimeValue;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Timeout;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.gradle.api.logging.Logger;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private SSLConnectionSocketFactory insecureSSLSocketFactory = null;

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate, int retries, int connectTimeoutMs, Map<String, String> headers, Logger logger, boolean quiet) {
        PoolingHttpClientConnectionManager cm;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (retries == 0) {
            builder.disableAutomaticRetries();
        } else {
            int maxRetries = retries;
            if (retries < 0) {
                maxRetries = Integer.MAX_VALUE;
            }
            builder.setRetryStrategy(new CustomHttpRequestRetryStrategy(maxRetries, TimeValue.ofSeconds(0L), logger, quiet));
        }
        builder.setRoutePlanner(new SystemDefaultRoutePlanner(null));
        if ("https".equals(httpHost.getSchemeName()) && acceptAnyCertificate) {
            SSLConnectionSocketFactory icsf = this.getInsecureSSLSocketFactory();
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", icsf).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.INSTANCE)).build();
            cm = new PoolingHttpClientConnectionManager(registry);
        } else {
            cm = PoolingHttpClientConnectionManagerBuilder.create().build();
        }
        cm.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(connectTimeoutMs)).build());
        builder.setConnectionManager(cm);
        builder.addRequestInterceptorLast(new StripPortsFromHostInterceptor(headers));
        if (logger.isDebugEnabled()) {
            DebugInterceptor di = new DebugInterceptor();
            builder.addExecInterceptorLast("debug-interceptor", di);
            builder.addResponseInterceptorFirst(di);
        }
        return builder.build();
    }

    private SSLConnectionSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = new SSLConnectionSocketFactory(sc, INSECURE_HOSTNAME_VERIFIER);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }
}

