/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.internal.Job;
import de.undercouch.gradle.tasks.download.internal.WorkerExecutorHelper;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class LegacyWorkerExecutorHelper
extends WorkerExecutorHelper {
    private final ExecutorService executorService = Executors.newWorkStealingPool();
    private final Queue<Future<Void>> futures = new ConcurrentLinkedQueue<Future<Void>>();

    @Override
    public void submit(Job job) {
        CompletableFuture f = new CompletableFuture();
        this.futures.add(f);
        this.executorService.submit(() -> {
            try {
                job.run();
                f.complete(null);
                this.futures.remove(f);
            }
            catch (IOException e) {
                f.completeExceptionally(e);
            }
        });
    }

    @Override
    public void await() {
        Future<Void> f;
        while ((f = this.futures.poll()) != null) {
            try {
                f.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean needsAwait() {
        return true;
    }
}

