/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download;

import de.undercouch.gradle.tasks.download.DownloadDetails;
import de.undercouch.gradle.tasks.download.DownloadSpec;
import de.undercouch.gradle.tasks.download.internal.CachingHttpClientFactory;
import de.undercouch.gradle.tasks.download.internal.DefaultDownloadDetails;
import de.undercouch.gradle.tasks.download.internal.HttpClientFactory;
import de.undercouch.gradle.tasks.download.internal.ProgressLoggerWrapper;
import de.undercouch.gradle.tasks.download.internal.WorkerExecutorFuture;
import de.undercouch.gradle.tasks.download.internal.WorkerExecutorHelper;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.ClientProtocolException;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.auth.AuthCache;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.auth.AuthScope;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.auth.Credentials;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.auth.CredentialsProvider;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.auth.CredentialsStore;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.config.RequestConfig;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.auth.BasicScheme;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.protocol.HttpClientContext;
import de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.utils.DateUtils;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ClassicHttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.Header;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpEntity;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.io.HttpClientResponseHandler;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.io.entity.StringEntity;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Timeout;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function0;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.util.GradleVersion;

public class DownloadAction
implements DownloadSpec,
Serializable {
    private static final GradleVersion HARD_MIN_GRADLE_VERSION = GradleVersion.version((String)"5.0");
    private final ProjectLayout projectLayout;
    private final Logger logger;
    private final Object servicesOwner;
    private final ObjectFactory objectFactory;
    private final boolean isOffline;
    private final List<Object> sourceObjects = new ArrayList<Object>(1);
    private List<URL> cachedSources;
    private int sourceObjectsCached;
    private transient Lock cachedSourcesLock = new ReentrantLock();
    private Object destObject;
    private File cachedDest;
    private transient Lock cachedDestLock = new ReentrantLock();
    private List<File> cachedOutputFiles;
    private transient Lock cachedOutputFilesLock = new ReentrantLock();
    private boolean quiet = false;
    private boolean overwrite = true;
    private boolean onlyIfModified = false;
    private boolean compress = true;
    private String username;
    private String password;
    private boolean preemptiveAuth = false;
    private Map<String, String> headers;
    private boolean acceptAnyCertificate = false;
    private int connectTimeoutMs = 30000;
    private int readTimeoutMs = 30000;
    private int retries = 0;
    private File downloadTaskDir;
    private boolean tempAndMove = false;
    private UseETag useETag = UseETag.FALSE;
    private String method = "GET";
    private String body;
    private Transformer<Boolean, Integer> statusValidator;
    private File cachedETagsFile;
    private transient Lock cachedETagsFileLock = new ReentrantLock();
    private final List<Action<? super DownloadDetails>> eachFileActions = new ArrayList<Action<? super DownloadDetails>>();
    private final AtomicInteger upToDate = new AtomicInteger(0);

    public DownloadAction(Project project) {
        this(project, null);
    }

    public DownloadAction(Project project, @Nullable Task task) {
        this(project.getLayout(), project.getLogger(), task != null ? task : project, project.getObjects(), project.getGradle().getStartParameter().isOffline(), (File)project.getLayout().getBuildDirectory().getAsFile().get());
    }

    DownloadAction(ProjectLayout projectLayout, Logger logger, Object servicesOwner, ObjectFactory objectFactory, boolean isOffline, File buildDir) {
        this.projectLayout = projectLayout;
        this.logger = logger;
        this.servicesOwner = servicesOwner;
        this.objectFactory = objectFactory;
        this.isOffline = isOffline;
        this.downloadTaskDir = new File(buildDir, "download-task");
    }

    public CompletableFuture<Void> execute() throws IOException {
        return this.execute(true);
    }

    public CompletableFuture<Void> execute(boolean throwOnError) throws IOException {
        if (GradleVersion.current().compareTo(HARD_MIN_GRADLE_VERSION) < 0 && !this.quiet) {
            throw new IllegalStateException("gradle-download-task requires Gradle 5.x or higher");
        }
        if (JavaVersion.current().compareTo((Enum)JavaVersion.VERSION_1_8) < 0 && !this.quiet) {
            throw new IllegalStateException("gradle-download-task requires Java 8 or higher");
        }
        if (this.sourceObjects.isEmpty()) {
            throw new IllegalArgumentException("Please provide a download source");
        }
        if (this.destObject == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        List<URL> sources = this.getSources();
        File dest = this.getDest();
        if (dest.equals(((Directory)this.projectLayout.getBuildDirectory().get()).getAsFile())) {
            dest.mkdirs();
        }
        if (sources.size() > 1 && !dest.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            } else {
                throw new IllegalArgumentException("If multiple sources are provided, the destination has to be a directory.");
            }
        }
        if (!this.eachFileActions.isEmpty() && sources.size() < 2) {
            throw new IllegalArgumentException("An 'eachFile' action can only be added if multiple sources are provided.");
        }
        List<File> destFiles = this.getOutputFiles();
        this.ensureTargetDirectoriesExist(destFiles);
        WorkerExecutorHelper workerExecutor = WorkerExecutorHelper.newInstance(this.objectFactory);
        CachingHttpClientFactory clientFactory = new CachingHttpClientFactory();
        CompletableFuture[] futures = new CompletableFuture[sources.size()];
        for (int i = 0; i < sources.size(); ++i) {
            CompletableFuture f;
            URL src = sources.get(i);
            File destFile = destFiles.get(i);
            futures[i] = f = new CompletableFuture();
            workerExecutor.submit(() -> {
                block5: {
                    ProgressLoggerWrapper progressLogger = new ProgressLoggerWrapper(this.logger);
                    if (!this.quiet) {
                        try {
                            progressLogger.init(this.servicesOwner, src.toString());
                        }
                        catch (Exception e) {
                            this.logger.error("Unable to get progress logger. Download progress will not be displayed.");
                        }
                    }
                    try {
                        this.execute(src, destFile, clientFactory, progressLogger);
                        f.complete(null);
                    }
                    catch (Throwable t) {
                        f.completeExceptionally(t);
                        if (!throwOnError) break block5;
                        throw t;
                    }
                }
            });
        }
        if (workerExecutor.needsAwait()) {
            workerExecutor.await();
        }
        WorkerExecutorFuture rf = new WorkerExecutorFuture(workerExecutor);
        CompletableFuture.allOf(futures).whenComplete((v, t) -> {
            try {
                clientFactory.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            if (t == null) {
                rf.complete(v);
            } else {
                rf.completeExceptionally((Throwable)t);
            }
        });
        return rf;
    }

    private void execute(URL src, File destFile, HttpClientFactory clientFactory, ProgressLoggerWrapper progressLogger) throws IOException {
        long timestamp;
        if (!this.overwrite && destFile.exists()) {
            if (!this.quiet) {
                this.logger.info("Destination file already exists. Skipping '" + destFile.getName() + "'");
            }
            this.upToDate.incrementAndGet();
            return;
        }
        progressLogger.setDestFileName(destFile.getName());
        if (this.isOffline) {
            if (destFile.exists()) {
                if (!this.quiet) {
                    this.logger.info("Skipping existing file '" + destFile.getName() + "' in offline mode.");
                }
                return;
            }
            throw new IllegalStateException("Unable to download file '" + src + "' in offline mode.");
        }
        long l = timestamp = this.onlyIfModified && destFile.exists() ? destFile.lastModified() : 0L;
        if ("file".equals(src.getProtocol())) {
            this.executeFileProtocol(src, timestamp, destFile, progressLogger);
        } else {
            this.executeHttpProtocol(src, clientFactory, timestamp, destFile, progressLogger);
        }
    }

    private void executeFileProtocol(URL src, long timestamp, File destFile, ProgressLoggerWrapper progressLogger) throws IOException {
        File srcFile = null;
        try {
            srcFile = new File(src.toURI());
            progressLogger.setSize(srcFile.length());
        }
        catch (URISyntaxException e) {
            this.logger.warn("Unable to determine file length.");
        }
        long lastModified = 0L;
        if (srcFile != null && (lastModified = srcFile.lastModified()) != 0L && timestamp >= lastModified) {
            if (!this.quiet) {
                this.logger.info("Not modified. Skipping '" + src + "'");
            }
            this.upToDate.incrementAndGet();
            return;
        }
        BufferedInputStream fileStream = new BufferedInputStream(src.openStream());
        this.streamAndMove(fileStream, destFile, progressLogger);
        if (this.onlyIfModified && lastModified > 0L) {
            destFile.setLastModified(lastModified);
        }
    }

    private void executeHttpProtocol(URL src, HttpClientFactory clientFactory, long timestamp, File destFile, ProgressLoggerWrapper progressLogger) throws IOException {
        HttpHost httpHost = new HttpHost(src.getProtocol(), src.getHost(), src.getPort());
        CloseableHttpClient client = clientFactory.createHttpClient(httpHost, this.acceptAnyCertificate, this.retries, this.connectTimeoutMs, this.headers, this.logger, this.quiet);
        String etag = null;
        if (this.onlyIfModified && this.useETag.enabled && destFile.exists()) {
            etag = this.getCachedETag(httpHost, src.getFile());
            if (!this.useETag.useWeakETags && this.isWeakETag(etag)) {
                etag = null;
            }
        }
        this.openConnection(httpHost, src.getFile(), timestamp, etag, client, response -> {
            long lastModified = this.parseLastModified(response);
            int code = response.getCode();
            if (code == 304 || lastModified != 0L && timestamp >= lastModified) {
                if (!this.quiet) {
                    this.logger.info("Not modified. Skipping '" + src + "'");
                }
                this.upToDate.incrementAndGet();
                return null;
            }
            this.performDownload(response, destFile, progressLogger);
            long newTimestamp = this.parseLastModified(response);
            if (this.onlyIfModified && newTimestamp > 0L) {
                destFile.setLastModified(newTimestamp);
            }
            if (this.onlyIfModified && this.useETag.enabled) {
                this.storeETag(httpHost, src.getFile(), response);
            }
            return null;
        });
    }

    private void performDownload(ClassicHttpResponse response, File destFile, ProgressLoggerWrapper progressLogger) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        long contentLength = entity.getContentLength();
        if (contentLength >= 0L) {
            progressLogger.setSize(contentLength);
        }
        InputStream is = entity.getContent();
        this.streamAndMove(is, destFile, progressLogger);
    }

    private void moveFile(File src, File dest, ProgressLoggerWrapper progressLogger) throws IOException {
        if (src.renameTo(dest)) {
            return;
        }
        try (InputStream is = Files.newInputStream(src.toPath(), new OpenOption[0]);){
            this.stream(is, dest, progressLogger);
        }
        if (!src.delete()) {
            throw new IOException("Could not delete temporary file '" + src.getAbsolutePath() + "' after copying it to '" + dest.getAbsolutePath() + "'.");
        }
    }

    private void streamAndMove(InputStream is, File destFile, ProgressLoggerWrapper progressLogger) throws IOException {
        if (!this.tempAndMove) {
            this.stream(is, destFile, progressLogger);
        } else {
            this.downloadTaskDir.mkdirs();
            File tempFile = File.createTempFile(destFile.getName(), ".part", this.downloadTaskDir);
            this.stream(is, tempFile, progressLogger);
            if (destFile.exists() && !destFile.delete()) {
                throw new IOException("Could not delete old destination file '" + destFile.getAbsolutePath() + "'.");
            }
            try {
                this.moveFile(tempFile, destFile, progressLogger);
            }
            catch (IOException e) {
                throw new IOException("Failed to move temporary file '" + tempFile.getAbsolutePath() + "' to destination file '" + destFile.getAbsolutePath() + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream(InputStream is, File destFile, ProgressLoggerWrapper progressLogger) throws IOException {
        try {
            progressLogger.started();
            boolean finished = false;
            try (AsynchronousFileChannel channel = AsynchronousFileChannel.open(destFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                int read;
                long pos = 0L;
                Future<Integer> writeFuture = null;
                byte[] buf1 = new byte[10240];
                byte[] buf2 = new byte[10240];
                ByteBuffer bb1 = ByteBuffer.wrap(buf1);
                ByteBuffer bb2 = ByteBuffer.wrap(buf2);
                while ((read = is.read(buf1)) >= 0) {
                    if (writeFuture != null) {
                        writeFuture.get();
                    }
                    bb1.position(0);
                    bb1.limit(read);
                    writeFuture = channel.write(bb1, pos);
                    pos += (long)read;
                    progressLogger.incrementProgress(read);
                    byte[] tmpBuf = buf1;
                    buf1 = buf2;
                    buf2 = tmpBuf;
                    ByteBuffer tmpBB = bb1;
                    bb1 = bb2;
                    bb2 = tmpBB;
                }
                if (writeFuture != null) {
                    writeFuture.get();
                }
                finished = true;
            }
            catch (InterruptedException e) {
                throw new IOException("Writing to destination file was interrupted", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException("Could not write to destination file", e);
            }
            finally {
                if (!finished) {
                    destFile.delete();
                }
            }
        }
        finally {
            is.close();
            progressLogger.completed();
        }
    }

    private void ensureTargetDirectoriesExist(List<File> destFiles) {
        HashSet<File> parentDirs = new HashSet<File>();
        for (File o : destFiles) {
            File parentDir = o.getParentFile();
            if (parentDir == null || !parentDirs.add(parentDir)) continue;
            parentDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readCachedETags() {
        this.cachedETagsFileLock.lock();
        try {
            Map<String, Object> cachedETags;
            File cachedETagsFile = this.getCachedETagsFile();
            if (cachedETagsFile.exists()) {
                JsonSlurper slurper = new JsonSlurper();
                cachedETags = (Map)slurper.parse(cachedETagsFile, "UTF-8");
            } else {
                cachedETags = new LinkedHashMap<String, Object>();
            }
            LinkedHashMap<String, Object> linkedHashMap = cachedETags;
            return linkedHashMap;
        }
        finally {
            this.cachedETagsFileLock.unlock();
        }
    }

    private String getCachedETag(HttpHost host, String file) {
        Map<String, Object> cachedETags = this.readCachedETags();
        Map hostMap = (Map)cachedETags.get(host.toURI());
        if (hostMap == null) {
            return null;
        }
        Map etagMap = (Map)hostMap.get(file);
        if (etagMap == null) {
            return null;
        }
        return (String)etagMap.get("ETag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeETag(HttpHost host, String file, HttpResponse response) throws IOException {
        Header etagHdr = response.getFirstHeader("ETag");
        if (etagHdr == null) {
            if (!this.quiet) {
                this.logger.warn("Server response does not include an entity tag (ETag).");
            }
            return;
        }
        String etag = etagHdr.getValue();
        if (this.isWeakETag(etag)) {
            if (this.useETag.displayWarningForWeak && !this.quiet) {
                this.logger.warn("Weak entity tag (ETag) encountered. Please make sure you want to compare resources based on weak ETags. If yes, set the 'useETag' flag to \"all\", otherwise set it to \"strongOnly\".");
            }
            if (!this.useETag.useWeakETags) {
                return;
            }
        }
        this.cachedETagsFileLock.lock();
        try {
            File parent = this.getCachedETagsFile().getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            Map<String, Object> cachedETags = this.readCachedETags();
            LinkedHashMap<String, String> etagMap = new LinkedHashMap<String, String>();
            etagMap.put("ETag", etag);
            String uri = host.toURI();
            LinkedHashMap hostMap = (LinkedHashMap)cachedETags.get(uri);
            if (hostMap == null) {
                hostMap = new LinkedHashMap();
                cachedETags.put(uri, hostMap);
            }
            hostMap.put(file, etagMap);
            String cachedETagsContents = JsonOutput.toJson(cachedETags);
            try (PrintWriter writer = new PrintWriter(this.getCachedETagsFile(), "UTF-8");){
                writer.write(cachedETagsContents);
                writer.flush();
            }
        }
        finally {
            this.cachedETagsFileLock.unlock();
        }
    }

    private boolean isWeakETag(String etag) {
        return etag != null && etag.startsWith("W/");
    }

    private File makeDestFile(URL src, boolean multipleSources) {
        boolean isDirectory;
        File destFile = this.getDest();
        if (destFile == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        boolean bl = isDirectory = destFile.isDirectory() || destFile.equals(((Directory)this.projectLayout.getBuildDirectory().get()).getAsFile());
        if (multipleSources || isDirectory) {
            String name = src.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            RelativePath path = RelativePath.parse((boolean)true, (String)name);
            if (!this.eachFileActions.isEmpty()) {
                DefaultDownloadDetails details = new DefaultDownloadDetails(path, src);
                for (Action<? super DownloadDetails> a : this.eachFileActions) {
                    a.execute((Object)details);
                }
                path = details.getRelativePath();
            }
            destFile = path.getFile(destFile);
        }
        return destFile;
    }

    private <T> void openConnection(HttpHost httpHost, String file, long timestamp, String etag, CloseableHttpClient client, HttpClientResponseHandler<T> responseHandler) throws IOException {
        HttpClientContext context = null;
        if (this.username != null && this.password != null) {
            context = HttpClientContext.create();
            UsernamePasswordCredentials c = new UsernamePasswordCredentials(this.username, this.password.toCharArray());
            this.addAuthentication(httpHost, c, context, this.preemptiveAuth);
        }
        HttpUriRequestBase req = new HttpUriRequestBase(this.method.toUpperCase(Locale.ROOT), URI.create(file));
        if (this.body != null) {
            req.setEntity(new StringEntity(this.body));
        }
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds(this.connectTimeoutMs)).setResponseTimeout(Timeout.ofMilliseconds(this.readTimeoutMs)).setContentCompressionEnabled(this.compress).build();
        req.setConfig(config);
        String scheme = httpHost.getSchemeName();
        String proxyHost = System.getProperty(scheme + ".proxyHost");
        String proxyPort = System.getProperty(scheme + ".proxyPort");
        String proxyUser = System.getProperty(scheme + ".proxyUser");
        String proxyPassword = System.getProperty(scheme + ".proxyPassword");
        if (proxyHost != null && proxyPort != null && proxyUser != null && proxyPassword != null) {
            if (context == null) {
                context = HttpClientContext.create();
            }
            int nProxyPort = Integer.parseInt(proxyPort);
            HttpHost proxy = new HttpHost(scheme, proxyHost, nProxyPort);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword.toCharArray());
            this.addAuthentication(proxy, credentials, context, false);
        }
        if (timestamp > 0L) {
            req.setHeader("If-Modified-Since", DateUtils.formatStandardDate(Instant.ofEpochMilli(timestamp)));
        }
        if (etag != null) {
            req.setHeader("If-None-Match", etag);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                req.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        client.execute(httpHost, req, context, (ClassicHttpResponse response) -> {
            boolean valid;
            int code = response.getCode();
            if (this.statusValidator != null) {
                valid = Boolean.TRUE.equals(this.statusValidator.transform((Object)code));
            } else {
                boolean bl = valid = code >= 200 && code <= 299 || code == 304;
            }
            if (!valid) {
                String phrase;
                String url = httpHost + file;
                String message = "HTTP status code: " + code + ", URL: " + url;
                if (code == 401 && !response.containsHeader("WWW-Authenticate")) {
                    message = message + ". Missing WWW-Authenticate header in response; use the preemptiveAuth flag to send credentials in the first request.";
                }
                phrase = (phrase = response.getReasonPhrase()) == null || phrase.isEmpty() ? message : phrase + " (" + message + ")";
                throw new ClientProtocolException(phrase);
            }
            return responseHandler.handleResponse(response);
        });
    }

    private void addAuthentication(HttpHost host, Credentials credentials, HttpClientContext context, boolean preemptiveAuth) {
        CredentialsProvider credsProvider;
        AuthCache authCache = context.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            context.setAuthCache(authCache);
        }
        if ((credsProvider = context.getCredentialsProvider()) == null) {
            credsProvider = new BasicCredentialsProvider();
            context.setCredentialsProvider(credsProvider);
        }
        if (preemptiveAuth) {
            BasicScheme basicAuth = new BasicScheme();
            basicAuth.initPreemptive(credentials);
            authCache.put(host, basicAuth);
        }
        ((CredentialsStore)credsProvider).setCredentials(new AuthScope(host), credentials);
    }

    private long parseLastModified(HttpResponse response) {
        Header header = response.getLastHeader("Last-Modified");
        if (header == null) {
            return 0L;
        }
        String value = header.getValue();
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        Instant date = DateUtils.parseStandardDate(value);
        if (date == null) {
            return 0L;
        }
        return date.toEpochMilli();
    }

    public boolean isUpToDate() {
        return this.upToDate.get() == this.getSources().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getOutputFiles() {
        List<URL> sources = this.getSources();
        this.cachedOutputFilesLock.lock();
        try {
            if (this.cachedOutputFiles != null && this.cachedOutputFiles.size() == sources.size()) {
                List<File> list = Collections.unmodifiableList(this.cachedOutputFiles);
                return list;
            }
            if (this.cachedOutputFiles == null || this.cachedOutputFiles.size() == 1) {
                this.cachedOutputFiles = new ArrayList<File>(sources.size());
            }
            boolean multipleSources = sources.size() > 1;
            HashSet<File> distinctFiles = new HashSet<File>(this.cachedOutputFiles);
            for (int i = this.cachedOutputFiles.size(); i < sources.size(); ++i) {
                File destFile = this.makeDestFile(sources.get(i), multipleSources);
                this.cachedOutputFiles.add(destFile);
                if (distinctFiles.add(destFile)) continue;
                throw new IllegalArgumentException("Duplicate destination file '" + destFile + "'");
            }
            List<File> list = Collections.unmodifiableList(this.cachedOutputFiles);
            return list;
        }
        finally {
            this.cachedOutputFilesLock.unlock();
        }
    }

    @Override
    public void src(Object src) {
        this.sourceObjects.add(src);
    }

    @Override
    public void dest(Object dest) {
        this.destObject = dest;
    }

    @Override
    public void quiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void onlyIfModified(boolean onlyIfModified) {
        this.onlyIfModified = onlyIfModified;
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.onlyIfModified(onlyIfNewer);
    }

    @Override
    public void compress(boolean compress) {
        this.compress = compress;
    }

    @Override
    public void username(String username) {
        this.username = username;
    }

    @Override
    public void password(String password) {
        this.password = password;
    }

    @Override
    public void preemptiveAuth(boolean preemptiveAuth) {
        this.preemptiveAuth = preemptiveAuth;
    }

    @Override
    public void headers(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        } else {
            this.headers.clear();
        }
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Override
    public void header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.acceptAnyCertificate = accept;
    }

    @Override
    public void connectTimeout(int milliseconds) {
        this.connectTimeoutMs = milliseconds;
    }

    @Override
    public void readTimeout(int milliseconds) {
        this.readTimeoutMs = milliseconds;
    }

    @Override
    public void retries(int retries) {
        this.retries = retries;
    }

    private File getDestinationFromDirProperty(Object dir) {
        if (dir instanceof Function0) {
            Function0 function = (Function0)dir;
            dir = function.invoke();
        }
        if (dir instanceof Closure) {
            Closure closure = (Closure)dir;
            dir = closure.call();
        }
        if (dir instanceof Provider) {
            dir = ((Provider)dir).getOrNull();
        }
        if (dir instanceof CharSequence) {
            return this.projectLayout.getProjectDirectory().file(dir.toString()).getAsFile();
        }
        if (dir instanceof Directory) {
            File f = ((Directory)dir).getAsFile();
            f.mkdirs();
            return f;
        }
        if (dir instanceof RegularFile) {
            return ((RegularFile)dir).getAsFile();
        }
        if (dir instanceof File) {
            return (File)dir;
        }
        return null;
    }

    @Override
    public void downloadTaskDir(Object dir) {
        this.downloadTaskDir = this.getDestinationFromDirProperty(dir);
        if (this.downloadTaskDir == null) {
            throw new IllegalArgumentException("download-task directory must either be a File or a CharSequence");
        }
    }

    @Override
    public void tempAndMove(boolean tempAndMove) {
        this.tempAndMove = tempAndMove;
    }

    @Override
    public void useETag(Object useETag) {
        this.useETag = UseETag.fromValue(useETag);
    }

    @Override
    public void cachedETagsFile(Object location) {
        if (location instanceof Function0) {
            Function0 function = (Function0)location;
            location = function.invoke();
        }
        if (location instanceof Closure) {
            Closure closure = (Closure)location;
            location = closure.call();
        }
        if (location instanceof Provider) {
            location = ((Provider)location).getOrNull();
        }
        if (location instanceof CharSequence) {
            this.cachedETagsFile = this.projectLayout.getProjectDirectory().file(location.toString()).getAsFile();
        } else if (location instanceof RegularFile) {
            this.cachedETagsFile = ((RegularFile)location).getAsFile();
        } else if (location instanceof File) {
            this.cachedETagsFile = (File)location;
        } else {
            throw new IllegalArgumentException("Location for cached ETags must either be a File or a CharSequence");
        }
    }

    @Override
    public void eachFile(Action<? super DownloadDetails> action) {
        this.eachFileActions.add(action);
    }

    @Override
    public void method(String method) {
        if (method == null) {
            throw new IllegalArgumentException("HTTP method must not be null");
        }
        this.method = method;
    }

    @Override
    public void body(String body) {
        this.body = body;
    }

    @Override
    public void validateStatus(Transformer<Boolean, Integer> validator) {
        this.statusValidator = validator;
    }

    private List<URL> convertSource(Object src) {
        ArrayList<URL> result = new ArrayList<URL>();
        if (src instanceof Function0) {
            Function0 function = (Function0)src;
            src = function.invoke();
        }
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if (src instanceof Provider) {
            src = ((Provider)src).getOrNull();
        }
        if (src instanceof CharSequence) {
            try {
                result.add(new URL(src.toString()));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid source URL", e);
            }
        } else if (src instanceof URL) {
            result.add((URL)src);
        } else if (src instanceof URI) {
            try {
                result.add(((URI)src).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid source URL", e);
            }
        } else if (src instanceof Collection) {
            Collection sc = (Collection)src;
            for (Object sco : sc) {
                result.addAll(this.convertSource(sco));
            }
        } else if (src != null && src.getClass().isArray()) {
            int len = Array.getLength(src);
            for (int i = 0; i < len; ++i) {
                Object sco = Array.get(src, i);
                result.addAll(this.convertSource(sco));
            }
        } else {
            throw new IllegalArgumentException("Download source must either be a URL, a URI, a CharSequence, a Collection or an array.");
        }
        return result;
    }

    private List<URL> getSources() {
        this.cachedSourcesLock.lock();
        try {
            if (this.cachedSources != null && this.sourceObjectsCached == this.sourceObjects.size()) {
                List<URL> list = this.cachedSources;
                return list;
            }
            if (this.cachedSources == null) {
                this.cachedSources = new ArrayList<URL>(this.sourceObjects.size());
            }
            for (int i = this.sourceObjectsCached; i < this.sourceObjects.size(); ++i) {
                this.cachedSources.addAll(this.convertSource(this.sourceObjects.get(i)));
            }
            this.sourceObjectsCached = this.sourceObjects.size();
            List<URL> list = this.cachedSources;
            return list;
        }
        finally {
            this.cachedSourcesLock.unlock();
        }
    }

    @Override
    public Object getSrc() {
        List<URL> sources = this.getSources();
        if (sources.size() == 1) {
            return sources.get(0);
        }
        return sources;
    }

    @Override
    public File getDest() {
        this.cachedDestLock.lock();
        try {
            if (this.cachedDest != null) {
                File file = this.cachedDest;
                return file;
            }
            this.cachedDest = this.getDestinationFromDirProperty(this.destObject);
            if (this.cachedDest == null) {
                throw new IllegalArgumentException("Download destination must be one of a File, Directory, RegularFile, or a CharSequence");
            }
            File file = this.cachedDest;
            return file;
        }
        finally {
            this.cachedDestLock.unlock();
        }
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isOnlyIfModified() {
        return this.onlyIfModified;
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.isOnlyIfModified();
    }

    @Override
    public boolean isCompress() {
        return this.compress;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isPreemptiveAuth() {
        return this.preemptiveAuth;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeoutMs;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeoutMs;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public File getDownloadTaskDir() {
        return this.downloadTaskDir;
    }

    @Override
    public boolean isTempAndMove() {
        return this.tempAndMove;
    }

    @Override
    public Object getUseETag() {
        return this.useETag.value;
    }

    @Override
    public File getCachedETagsFile() {
        this.cachedETagsFileLock.lock();
        try {
            if (this.cachedETagsFile == null) {
                File file = new File(this.downloadTaskDir, "etags.json");
                return file;
            }
            File file = this.cachedETagsFile;
            return file;
        }
        finally {
            this.cachedETagsFileLock.unlock();
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cachedSourcesLock = new ReentrantLock();
        this.cachedDestLock = new ReentrantLock();
        this.cachedOutputFilesLock = new ReentrantLock();
        this.cachedETagsFileLock = new ReentrantLock();
    }

    private static enum UseETag {
        FALSE(Boolean.FALSE, false, false, false),
        TRUE(Boolean.TRUE, true, true, true),
        ALL("all", true, true, false),
        STRONG_ONLY("strongOnly", true, false, false);

        final Object value;
        final boolean enabled;
        final boolean useWeakETags;
        final boolean displayWarningForWeak;

        private UseETag(Object value, boolean useAnyETag, boolean useWeakETags, boolean displayWarningForWeak) {
            this.value = value;
            this.enabled = useAnyETag;
            this.useWeakETags = useWeakETags;
            this.displayWarningForWeak = displayWarningForWeak;
        }

        static UseETag fromValue(Object value) {
            if (UseETag.TRUE.value.equals(value)) {
                return TRUE;
            }
            if (UseETag.FALSE.value.equals(value)) {
                return FALSE;
            }
            if (value instanceof String) {
                String s = (String)value;
                if (UseETag.ALL.value.equals(s)) {
                    return ALL;
                }
                if (UseETag.STRONG_ONLY.value.equals(s)) {
                    return STRONG_ONLY;
                }
                if ("true".equalsIgnoreCase(s)) {
                    return TRUE;
                }
                if ("false".equalsIgnoreCase(s)) {
                    return TRUE;
                }
            }
            throw new IllegalArgumentException("Illegal value for 'useETag' flag");
        }
    }
}

