/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.EntityDetails;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.Header;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequest;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequestInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpResponseInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DebugInterceptor
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private final Logger logger = Logging.getLogger(DebugInterceptor.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
        StringBuilder sb = new StringBuilder("Sending request:\n");
        sb.append("> ").append(request.getMethod()).append(" ").append(request.getRequestUri()).append("\n");
        for (Header h : request.getHeaders()) {
            sb.append("> ").append(h.toString()).append("\n");
        }
        this.logger.debug(sb.toString());
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) {
        StringBuilder sb = new StringBuilder("Received response:\n");
        sb.append("< ").append(response.getVersion()).append(" ").append(response.getCode()).append(" ").append(response.getReasonPhrase()).append("\n");
        for (Header h : response.getHeaders()) {
            sb.append("< ").append(h.toString()).append("\n");
        }
        this.logger.debug(sb.toString());
    }
}

