/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.bootstrap;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.Internal;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.concurrent.Cancellable;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.concurrent.CancellableDependency;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.concurrent.ComplexFuture;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.concurrent.FutureCallback;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.concurrent.FutureContribution;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.function.Callback;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.function.Decorator;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.function.Resolver;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ConnectionClosedException;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.EntityDetails;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.Header;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpException;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpResponse;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ProtocolException;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.impl.bootstrap.AsyncRequester;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.CapacityChannel;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.DataStreamChannel;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.HandlerFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.RequestChannel;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.command.ShutdownCommand;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpCoreContext;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.impl.nio.bootstrap.CancellableExecution;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.nio.pool.H2ConnPool;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.net.URIAuthority;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.Command;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOReactorConfig;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOSession;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.IOSessionListener;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.TimeValue;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;

public class H2MultiplexingRequester
extends AsyncRequester {
    private final H2ConnPool connPool;

    @Internal
    public H2MultiplexingRequester(IOReactorConfig ioReactorConfig, IOEventHandlerFactory eventHandlerFactory, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
        super(eventHandlerFactory, ioReactorConfig, ioSessionDecorator, exceptionCallback, sessionListener, ShutdownCommand.GRACEFUL_IMMEDIATE_CALLBACK, DefaultAddressResolver.INSTANCE);
        this.connPool = new H2ConnPool(this, addressResolver, tlsStrategy);
    }

    public void closeIdle(TimeValue idleTime) {
        this.connPool.closeIdle(idleTime);
    }

    public Set<HttpHost> getRoutes() {
        return this.connPool.getRoutes();
    }

    public TimeValue getValidateAfterInactivity() {
        return this.connPool.getValidateAfterInactivity();
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.connPool.setValidateAfterInactivity(timeValue);
    }

    public Cancellable execute(AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, Timeout timeout, HttpContext context) {
        Args.notNull(exchangeHandler, "Exchange handler");
        Args.notNull(timeout, "Timeout");
        Args.notNull(context, "Context");
        CancellableExecution cancellableExecution = new CancellableExecution();
        this.execute(exchangeHandler, pushHandlerFactory, cancellableExecution, timeout, context);
        return cancellableExecution;
    }

    public Cancellable execute(AsyncClientExchangeHandler exchangeHandler, Timeout timeout, HttpContext context) {
        return this.execute(exchangeHandler, null, timeout, context);
    }

    private void execute(final AsyncClientExchangeHandler exchangeHandler, final HandlerFactory<AsyncPushConsumer> pushHandlerFactory, final CancellableDependency cancellableDependency, Timeout timeout, final HttpContext context) {
        Args.notNull(exchangeHandler, "Exchange handler");
        Args.notNull(timeout, "Timeout");
        Args.notNull(context, "Context");
        try {
            exchangeHandler.produceRequest((request, entityDetails, httpContext) -> {
                String scheme = request.getScheme();
                URIAuthority authority = request.getAuthority();
                if (authority == null) {
                    throw new ProtocolException("Request authority not specified");
                }
                HttpHost target = new HttpHost(scheme, authority);
                this.connPool.getSession(target, timeout, new FutureCallback<IOSession>(){

                    @Override
                    public void completed(IOSession ioSession) {
                        ioSession.enqueue(new RequestExecutionCommand(new AsyncClientExchangeHandler(){

                            @Override
                            public void releaseResources() {
                                exchangeHandler.releaseResources();
                            }

                            @Override
                            public void produceRequest(RequestChannel channel, HttpContext httpContext) throws HttpException, IOException {
                                channel.sendRequest(request, entityDetails, httpContext);
                            }

                            @Override
                            public int available() {
                                return exchangeHandler.available();
                            }

                            @Override
                            public void produce(DataStreamChannel channel) throws IOException {
                                exchangeHandler.produce(channel);
                            }

                            @Override
                            public void consumeInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                                exchangeHandler.consumeInformation(response, httpContext);
                            }

                            @Override
                            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
                                exchangeHandler.consumeResponse(response, entityDetails, httpContext);
                            }

                            @Override
                            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                                exchangeHandler.updateCapacity(capacityChannel);
                            }

                            @Override
                            public void consume(ByteBuffer src) throws IOException {
                                exchangeHandler.consume(src);
                            }

                            @Override
                            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                                exchangeHandler.streamEnd(trailers);
                            }

                            @Override
                            public void cancel() {
                                exchangeHandler.cancel();
                            }

                            @Override
                            public void failed(Exception cause) {
                                exchangeHandler.failed(cause);
                            }
                        }, pushHandlerFactory, cancellableDependency, context), Command.Priority.NORMAL);
                        if (!ioSession.isOpen()) {
                            exchangeHandler.failed(new ConnectionClosedException());
                        }
                    }

                    @Override
                    public void failed(Exception ex) {
                        exchangeHandler.failed(ex);
                    }

                    @Override
                    public void cancelled() {
                        exchangeHandler.cancel();
                    }
                });
            }, context);
        }
        catch (HttpException | IOException ex) {
            exchangeHandler.failed(ex);
        }
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, Timeout timeout, HttpContext context, FutureCallback<T> callback) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        Args.notNull(timeout, "Timeout");
        final ComplexFuture<T> future = new ComplexFuture<T>(callback);
        BasicClientExchangeHandler<T> exchangeHandler = new BasicClientExchangeHandler<T>(requestProducer, responseConsumer, new FutureContribution<T>(future){

            @Override
            public void completed(T result) {
                future.completed(result);
            }
        });
        this.execute(exchangeHandler, pushHandlerFactory, future, timeout, context != null ? context : HttpCoreContext.create());
        return future;
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, Timeout timeout, HttpContext context, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, timeout, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, Timeout timeout, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, timeout, null, callback);
    }
}

