/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.Executer;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.json.simple.JSONObject;

public class Main {
    public static boolean exit = true;
    Executer exe = new Executer();

    public void usage(String msg) {
        if (msg != null && msg.length() > 0) {
            System.err.println(msg);
            System.out.println();
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new Comparator<Option>(){
            private static final String OPTS_ORDER = "hcrio";

            @Override
            public int compare(Option o1, Option o2) {
                return OPTS_ORDER.indexOf(o1.getLongOpt()) - OPTS_ORDER.indexOf(o2.getLongOpt());
            }
        });
        formatter.printHelp("java -jar bives.jar", this.exe.getOptions(), true);
        if (exit) {
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        Logger.getRootLogger().setLevel(Level.OFF);
        LOGGER.setLogToStdErr((boolean)false);
        LOGGER.setLogToStdOut((boolean)false);
        LOGGER.setLevel((int)8);
        Main m = new Main();
        try {
            m.run(args);
        }
        catch (HelpException e) {
            m.usage(null);
        }
        catch (Exception e) {
            m.usage(e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    public static CommandLine parseCommandLine(String[] args, Executer exe) throws HelpException, ExecutionException {
        Options options = exe.getOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                throw new HelpException();
            }
        }
        catch (ParseException e) {
            throw new ExecutionException("Parsing of command line options failed.  Reason: " + e.getMessage());
        }
        return line;
    }

    public void run(String[] args) throws Exception {
        List remainingArgs;
        String file1 = null;
        String file2 = null;
        int output = 0;
        JSONObject toReturn = new JSONObject();
        File outFile = null;
        CommandLine line = Main.parseCommandLine(args, this.exe);
        if (line.hasOption("debug")) {
            LOGGER.setLogToStdErr((boolean)true);
            LOGGER.setLevel((int)14);
        }
        if (line.hasOption("debugg")) {
            LOGGER.setLogToStdErr((boolean)true);
            LOGGER.setLevel((int)15);
            LOGGER.setLogStackTrace((boolean)true);
        }
        if (line.hasOption("json")) {
            output = 2;
        }
        if (line.hasOption("xml")) {
            output = 1;
        }
        if (line.hasOption("out")) {
            outFile = new File(line.getOptionValue("out"));
        }
        if ((remainingArgs = line.getArgList()).size() > 3) {
            throw new ExecutionException("Parsing of command line options failed. Do not know what to do with these arguments: " + remainingArgs);
        }
        if (remainingArgs.size() < 1) {
            throw new ExecutionException("Parsing of command line options failed. need at least one file");
        }
        file1 = (String)remainingArgs.get(0);
        if (remainingArgs.size() == 2) {
            file2 = (String)remainingArgs.get(1);
        }
        if (file1 == null) {
            throw new ExecutionException("no file provided");
        }
        if (!file1.matches("^https?://.*")) {
            File tmp = new File(file1);
            if (!tmp.exists()) {
                throw new ExecutionException("cannot find " + tmp.getAbsolutePath());
            }
            if (!tmp.canRead()) {
                throw new ExecutionException("cannot read " + tmp.getAbsolutePath());
            }
            file1 = tmp.toURI().toURL().toString();
        }
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (file2 == null) {
            this.exe.executeSingle(file1, toReturn, line, errors);
        } else {
            if (!file2.matches("^https?://.*")) {
                File tmp = new File(file2);
                if (!tmp.exists()) {
                    throw new ExecutionException("cannot find " + tmp.getAbsolutePath());
                }
                if (!tmp.canRead()) {
                    throw new ExecutionException("cannot read " + tmp.getAbsolutePath());
                }
                file2 = tmp.toURI().toURL().toString();
            }
            this.exe.executeCompare(file1, file2, toReturn, line, errors);
        }
        if (toReturn.size() < 1) {
            throw new ExecutionException("invalid call. no output produced.");
        }
        PrintStream out = System.out;
        if (outFile != null) {
            out = new PrintStream((OutputStream)new FileOutputStream(outFile), true, "UTF-8");
        }
        if (output == 0) {
            for (Exception e : errors) {
                System.err.println("ERROR: " + e);
            }
            for (Object ret : toReturn.keySet()) {
                out.println(toReturn.get(ret));
            }
        } else if (output == 1) {
            Element root = new Element("bivesResult");
            Document document = new Document(root);
            for (Object ret : toReturn.keySet()) {
                Element el = new Element(ret.toString());
                el.setText(toReturn.get(ret).toString());
                root.addContent((Content)el);
            }
            out.println(XmlTools.prettyPrintDocument((Document)document));
        } else {
            out.println(toReturn);
        }
        if (outFile != null) {
            out.close();
        }
    }

    public static class ExecutionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExecutionException(String msg) {
            super(msg);
        }
    }

    public static class HelpException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

