/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive;

import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.meta.MetaDataFile;
import de.unirostock.sems.cbarchive.meta.MetaDataHolder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import org.jdom2.JDOMException;

public class ArchiveEntry
extends MetaDataHolder {
    private CombineArchive archive;
    private Path relativeName;
    private URI format;

    public ArchiveEntry(CombineArchive archive, Path relativeName, URI format) {
        this.archive = archive;
        this.relativeName = relativeName;
        this.format = format;
    }

    public File extractFile(File target) throws IOException {
        return this.archive.extract(this.relativeName, target);
    }

    public CombineArchive getArchive() {
        return this.archive;
    }

    public boolean isMainEntry() {
        return this.archive.getMainEntries().contains(this);
    }

    @Deprecated
    public File getFile() throws IOException {
        return this.extractFile(File.createTempFile("combineArchive", Utils.getExtension(this.relativeName.getFileName().toString())));
    }

    public Path getPath() {
        return this.relativeName;
    }

    public String getFileName() {
        return this.relativeName.getFileName().toString();
    }

    public String getFilePath() {
        return this.relativeName.toString();
    }

    @Override
    public String getEntityPath() {
        return this.getFilePath();
    }

    public URI getFormat() {
        return this.format;
    }

    public void setFormat(URI format) {
        this.format = format;
    }

    public int addAllDescriptions(File metaDataFile) throws JDOMException, IOException {
        return MetaDataFile.addAllMetaToEntry(metaDataFile.toPath(), this);
    }
}

