/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive;

import de.binfalse.bflog.LOGGER;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class Utils {
    public static final Namespace rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    public static final Namespace dcNS = Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/");
    public static final Namespace vcNS = Namespace.getNamespace((String)"vCard", (String)"http://www.w3.org/2006/vcard/ns#");
    public static final Namespace omexSpecNs = Namespace.getNamespace((String)"http://identifiers.org/combine.specifications/omex");
    public static final Namespace omexNs = Namespace.getNamespace((String)"http://identifiers.org/combine.specifications/omex-manifest");
    public static final SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
    public static final int BUFFER_SIZE = 8192;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final CopyOption[] COPY_OPTION = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};

    public static final Document readXmlDocument(Path fileToRead) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        return builder.build(Files.newInputStream(fileToRead, StandardOpenOption.READ));
    }

    public static List<Element> getElementsByTagName(Element parent, String name, Namespace ns) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        ArrayList<Element> togo = new ArrayList<Element>();
        togo.add(parent);
        while (togo.size() > 0) {
            parent = (Element)togo.remove(0);
            nodeList.addAll(parent.getChildren(name, ns));
            togo.addAll(0, parent.getChildren());
        }
        return nodeList;
    }

    public static String prettyPrintDocument(Document doc) throws IOException, TransformerException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(doc);
    }

    public static String getExtension(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot >= 0) {
            return fileName.substring(dot + 1);
        }
        return null;
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Utils.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static URI getOmexMetaDataUri() {
        try {
            return new URI("http://identifiers.org/combine.specifications/omex-metadata");
        }
        catch (URISyntaxException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"failed to create omex meta data uri. that shouldn't happen!!!"});
            return null;
        }
    }

    public static URI getOmexSpecUri() {
        try {
            return new URI("http://identifiers.org/combine.specifications/omex");
        }
        catch (URISyntaxException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"failed to create omex spec uri. that shouldn't happen!!!"});
            return null;
        }
    }

    public static URI getOmexManifestUri() {
        try {
            return new URI("http://identifiers.org/combine.specifications/omex-manifest");
        }
        catch (URISyntaxException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"failed to create omex manifest uri. that shouldn't happen!!!"});
            return null;
        }
    }

    public static String pathFixer(String path) {
        if (!File.separator.equals("/")) {
            path = path.replaceAll(File.separator.replaceAll("\\\\", "\\\\\\\\"), "/");
        }
        return path;
    }

    public static class SimpleOutputStream
    extends OutputStream {
        private StringBuilder string = new StringBuilder();

        @Override
        public void write(int b) throws IOException {
            this.string.append((char)b);
        }

        public String toString() {
            return this.string.toString();
        }

        public void reset() {
            this.string = new StringBuilder();
        }
    }
}

