/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataRows;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.filter.FilterPredicate;

public class ColumnSelection {
    private DataFrameColumn[] columns;
    private DataFrame dataFrame;

    public ColumnSelection(DataFrame dataFrame, DataFrameColumn ... columns) {
        this.dataFrame = dataFrame;
        this.columns = columns;
    }

    public DataFrame where(String colName, Comparable value) {
        DataRows rows = this.dataFrame.selectRows(colName, value);
        return this.createDataFrame(rows);
    }

    public DataFrame where(FilterPredicate predicate) {
        DataRows rows = this.dataFrame.selectRows(predicate);
        return this.createDataFrame(rows);
    }

    public DataFrame where(String predicateString) {
        DataRows rows = this.dataFrame.selectRows(predicateString);
        return this.createDataFrame(rows);
    }

    public DataFrame whereIndex(String indexName, Comparable ... values) {
        DataRows rows = this.dataFrame.selectRowsByIndex(indexName, values);
        return this.createDataFrame(rows);
    }

    public DataFrame allRows() {
        DataRows rows = this.dataFrame.getRows();
        return this.createDataFrame(rows);
    }

    private DataFrame createDataFrame(DataRows rows) {
        DefaultDataFrame df = new DefaultDataFrame();
        for (DataFrameColumn column : this.columns) {
            df.addColumn((DataFrameColumn)column.copyEmpty());
        }
        DataRows newRows = new DataRows(df, rows);
        df.set(newRows);
        return df;
    }
}

