/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.ColumnAppender;
import de.unknownreality.dataframe.ColumnSelection;
import de.unknownreality.dataframe.ColumnTypeMap;
import de.unknownreality.dataframe.DataFrameBuilder;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataFrameLoader;
import de.unknownreality.dataframe.DataFrameWriter;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.DataRows;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.column.BooleanColumn;
import de.unknownreality.dataframe.column.ByteColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.FloatColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.NumberColumn;
import de.unknownreality.dataframe.column.ShortColumn;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.index.Index;
import de.unknownreality.dataframe.io.DataIterator;
import de.unknownreality.dataframe.io.DataReader;
import de.unknownreality.dataframe.io.DataWriter;
import de.unknownreality.dataframe.io.ReadFormat;
import de.unknownreality.dataframe.io.WriteFormat;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.sort.SortColumn;
import de.unknownreality.dataframe.transform.DataFrameTransform;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;

public interface DataFrame
extends DataContainer<DataFrameHeader, DataRow> {
    public String getName();

    public void setName(String var1);

    public int getVersion();

    public DataFrame setPrimaryKey(String ... var1);

    public DataFrame setPrimaryKey(DataFrameColumn ... var1);

    public DataFrame removePrimaryKey();

    public DataFrame removeIndex(String var1);

    public DataFrame renameColumn(String var1, String var2);

    public ColumnSelection selectColumns(String ... var1);

    public ColumnSelection selectColumns(DataFrameColumn ... var1);

    public DataFrame addColumn(DataFrameColumn var1);

    public <T extends Comparable<T>> DataFrame addColumn(Class<T> var1, String var2);

    public <T extends Comparable<T>> DataFrame addColumn(Class<T> var1, String var2, ColumnTypeMap var3);

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrame addColumn(Class<T> var1, String var2, ColumnTypeMap var3, ColumnAppender<T> var4);

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrame addColumn(Class<C> var1, String var2, ColumnAppender<T> var3);

    public DataFrame addBooleanColumn(String var1);

    public DataFrame addByteColumn(String var1);

    public DataFrame addDoubleColumn(String var1);

    public DataFrame addFloatColumn(String var1);

    public DataFrame addIntegerColumn(String var1);

    public DataFrame addLongColumn(String var1);

    public DataFrame addShortColumn(String var1);

    public DataFrame addStringColumn(String var1);

    public DataFrame addColumns(Collection<DataFrameColumn> var1);

    public DataFrame addColumns(DataFrameColumn ... var1);

    public DataFrame replaceColumn(DataFrameColumn var1, DataFrameColumn var2);

    public DataFrame replaceColumn(String var1, DataFrameColumn var2);

    public DataFrame append(DataFrame var1, int var2);

    public DataFrame append(Comparable ... var1);

    public DataFrame append(DataRow var1);

    public DataFrame appendMatchingRow(DataRow var1);

    public DataFrame update(DataRow var1);

    public DataFrame set(DataFrameHeader var1);

    public DataFrame set(DataRows var1);

    public DataFrame removeColumn(String var1);

    public DataFrame removeColumn(DataFrameColumn var1);

    public DataFrame sort(SortColumn ... var1);

    public DataFrame sort(Comparator<DataRow> var1);

    public DataFrame sort(String var1);

    public DataFrame sort(String var1, SortColumn.Direction var2);

    public DataFrame shuffle();

    public DataFrame select(String var1, Comparable var2);

    public DataRow selectFirst(String var1, Comparable var2);

    public DataRow selectFirst(String var1);

    public DataRow selectFirst(FilterPredicate var1);

    public DataFrame select(FilterPredicate var1);

    public DataFrame select(String var1);

    public DataFrame filter(String var1);

    public DataFrame filter(FilterPredicate var1);

    public DataRows selectRows(String var1, Comparable var2);

    public DataRows selectRows(String var1);

    public DataRows selectRows(FilterPredicate var1);

    public DataFrame transform(DataFrameTransform var1);

    public DataRow selectByPrimaryKey(Comparable ... var1);

    public DataFrame reverse();

    public DataFrame addIndex(String var1, String ... var2);

    public DataFrame addIndex(String var1, DataFrameColumn ... var2);

    public DataFrame addIndex(Index var1);

    public int size();

    public boolean isEmpty();

    public DataFrame subset(int var1, int var2);

    public DataFrame filterSubset(int var1, int var2);

    public DataFrame selectSubset(int var1, int var2);

    public DataRows getRows(int var1, int var2);

    public DataRows getRows();

    @Override
    public DataFrameHeader getHeader();

    public DataFrame concat(DataFrame var1);

    public DataFrame concat(Collection<DataFrame> var1);

    public DataFrame concat(DataFrame ... var1);

    public boolean isCompatible(DataFrame var1);

    public DataRow getRow(int var1);

    public Collection<String> getColumnNames();

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrameColumn<T, C> getColumn(String var1);

    public <T extends DataFrameColumn> T getColumn(String var1, Class<T> var2);

    public <T extends Number, C extends NumberColumn<T, C>> NumberColumn<T, C> getNumberColumn(String var1);

    public StringColumn getStringColumn(String var1);

    public DoubleColumn getDoubleColumn(String var1);

    public IntegerColumn getIntegerColumn(String var1);

    public FloatColumn getFloatColumn(String var1);

    public BooleanColumn getBooleanColumn(String var1);

    public ByteColumn getByteColumn(String var1);

    public LongColumn getLongColumn(String var1);

    public ShortColumn getShortColumn(String var1);

    public DataGrouping groupBy(String ... var1);

    public JoinedDataFrame joinLeft(DataFrame var1, String ... var2);

    public JoinedDataFrame joinLeft(DataFrame var1, JoinColumn ... var2);

    public JoinedDataFrame joinLeft(DataFrame var1, String var2, String var3, JoinColumn ... var4);

    public JoinedDataFrame joinRight(DataFrame var1, String ... var2);

    public JoinedDataFrame joinRight(DataFrame var1, JoinColumn ... var2);

    public JoinedDataFrame joinRight(DataFrame var1, String var2, String var3, JoinColumn ... var4);

    public JoinedDataFrame joinInner(DataFrame var1, String ... var2);

    public JoinedDataFrame joinInner(DataFrame var1, JoinColumn ... var2);

    public JoinedDataFrame joinInner(DataFrame var1, String var2, String var3, JoinColumn ... var4);

    public JoinedDataFrame joinOuter(DataFrame var1, String ... var2);

    public JoinedDataFrame joinOuter(DataFrame var1, JoinColumn ... var2);

    public JoinedDataFrame joinOuter(DataFrame var1, String var2, String var3, JoinColumn ... var4);

    public DataFrame copy();

    public boolean containsColumn(DataFrameColumn var1);

    public boolean isIndexColumn(DataFrameColumn var1);

    public DataRows selectRowsByIndex(String var1, Comparable ... var2);

    public DataRows selectRows(Collection<Integer> var1);

    public DataRow selectFirstRowByIndex(String var1, Comparable ... var2);

    public DataFrame selectByIndex(String var1, Comparable ... var2);

    public Collection<DataFrameColumn> getColumns();

    public Iterable<? extends DataRow> rows();

    public static DataFrame create() {
        return new DefaultDataFrame();
    }

    public static DataFrame create(String name) {
        return new DefaultDataFrame(name);
    }

    public static DataFrameBuilder builder() {
        return new DataFrameBuilder();
    }

    public static DataFrame load(File file) {
        return DataFrameLoader.load(file);
    }

    public static DataFrame load(String content) {
        return DataFrameLoader.load(content);
    }

    public static DataFrame load(String resource, ClassLoader classLoader) {
        return DataFrameLoader.load(resource, classLoader);
    }

    public static DataFrame load(URL url) {
        return DataFrameLoader.load(url);
    }

    public static DataFrame load(byte[] bytes) {
        return DataFrameLoader.load(bytes);
    }

    public static DataFrame load(InputStream is) {
        return DataFrameLoader.load(is);
    }

    public static DataFrame load(Reader reader) {
        return DataFrameLoader.load(reader);
    }

    public static DataFrame load(File file, ReadFormat readFormat) {
        return DataFrameLoader.load(file, readFormat);
    }

    public static DataFrame load(String content, ReadFormat readFormat) {
        return DataFrameLoader.load(content, readFormat);
    }

    public static DataFrame load(String resource, ClassLoader classLoader, ReadFormat readFormat) {
        return DataFrameLoader.load(resource, classLoader, readFormat);
    }

    public static DataFrame load(URL url, ReadFormat readFormat) {
        return DataFrameLoader.load(url, readFormat);
    }

    public static DataFrame load(byte[] bytes, ReadFormat readFormat) {
        return DataFrameLoader.load(bytes, readFormat);
    }

    public static DataFrame load(InputStream is, ReadFormat readFormat) {
        return DataFrameLoader.load(is, readFormat);
    }

    public static DataFrame load(Reader reader, ReadFormat readFormat) {
        return DataFrameLoader.load(reader, readFormat);
    }

    public static DataFrame load(File file, DataReader reader) {
        return DataFrameLoader.load(file, reader);
    }

    public static DataFrame load(String content, DataReader reader) {
        return DataFrameLoader.load(content, reader);
    }

    public static DataFrame load(String resource, ClassLoader classLoader, DataReader reader) {
        return DataFrameLoader.load(resource, classLoader, reader);
    }

    public static DataFrame load(URL url, DataReader reader) {
        return DataFrameLoader.load(url, reader);
    }

    public static DataFrame load(byte[] bytes, DataReader reader) {
        return DataFrameLoader.load(bytes, reader);
    }

    public static DataFrame load(InputStream is, DataReader reader) {
        return DataFrameLoader.load(is, reader);
    }

    public static DataFrame load(Reader r, DataReader reader) {
        return DataFrameLoader.load(r, reader);
    }

    public static DataFrame load(DataIterator<?> dataIterator) {
        return DataFrameLoader.load(dataIterator);
    }

    public static DataFrame load(DataIterator<?> dataIterator, FilterPredicate predicate) {
        return DataFrameLoader.load(dataIterator, predicate);
    }

    public static DataFrame fromCSV(File file, char separator, boolean header) {
        return DataFrameLoader.fromCSV(file, separator, header);
    }

    public static DataFrame fromCSV(String content, char separator, boolean header) {
        return DataFrameLoader.fromCSV(content, separator, header);
    }

    public static DataFrame fromCSV(String resource, ClassLoader classLoader, char separator, boolean header) {
        return DataFrameLoader.fromCSV(resource, classLoader, separator, header);
    }

    public static DataFrame fromCSV(URL url, char separator, boolean header) {
        return DataFrameLoader.fromCSV(url, separator, header);
    }

    public static DataFrame fromCSV(byte[] bytes, char separator, boolean header) {
        return DataFrameLoader.fromCSV(bytes, separator, header);
    }

    public static DataFrame fromCSV(InputStream is, char separator, boolean header) {
        return DataFrameLoader.fromCSV(is, separator, header);
    }

    public static DataFrame fromCSV(Reader reader, char separator, boolean header) {
        return DataFrameLoader.fromCSV(reader, separator, header);
    }

    public static DataFrame fromCSV(File file, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(file, separator, headerPrefix);
    }

    public static DataFrame fromCSV(String content, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(content, separator, headerPrefix);
    }

    public static DataFrame fromCSV(String resource, ClassLoader classLoader, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(resource, classLoader, separator, headerPrefix);
    }

    public static DataFrame fromCSV(URL url, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(url, separator, headerPrefix);
    }

    public static DataFrame fromCSV(byte[] bytes, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(bytes, separator, headerPrefix);
    }

    public static DataFrame fromCSV(InputStream is, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(is, separator, headerPrefix);
    }

    public static DataFrame fromCSV(Reader r, char separator, String headerPrefix) {
        return DataFrameLoader.fromCSV(r, separator, headerPrefix);
    }

    default public void write(File file, DataWriter dataWriter) {
        DataFrameWriter.write(file, this, dataWriter);
    }

    default public void write(File file, DataWriter dataWriter, boolean writeMetaFile) {
        DataFrameWriter.write(file, this, dataWriter, writeMetaFile);
    }

    default public void write(Writer writer, DataWriter dataWriter) {
        DataFrameWriter.write(writer, this, dataWriter);
    }

    default public void write(OutputStream outputStream, DataWriter dataWriter) {
        DataFrameWriter.write(outputStream, this, dataWriter);
    }

    default public void write(File file, WriteFormat writeFormat) {
        DataFrameWriter.write(file, this, writeFormat);
    }

    default public void write(File file, WriteFormat writeFormat, boolean writeMetaFile) {
        DataFrameWriter.write(file, this, writeFormat, writeMetaFile);
    }

    default public void write(Writer writer, WriteFormat writeFormat) {
        DataFrameWriter.write(writer, this, writeFormat);
    }

    default public void write(OutputStream outputStream, WriteFormat writeFormat) {
        DataFrameWriter.write(outputStream, this, writeFormat);
    }

    default public void write(File file) {
        DataFrameWriter.write(file, this);
    }

    default public void write(File file, boolean writeMetaFile) {
        DataFrameWriter.write(file, this, writeMetaFile);
    }

    default public void write(Writer writer) {
        DataFrameWriter.write(writer, this);
    }

    default public void write(OutputStream outputStream) {
        DataFrameWriter.write(outputStream, this);
    }

    default public void writeCSV(File file, char separator, boolean writeHeader) {
        DataFrameWriter.writeCSV(file, this, separator, writeHeader);
    }

    default public void writeCSV(File file, char separator, boolean writeHeader, boolean writeMetaFile) {
        DataFrameWriter.writeCSV(file, this, separator, writeHeader, writeMetaFile);
    }

    default public void writeCSV(Writer writer, char separator, boolean writeHeader) {
        DataFrameWriter.writeCSV(writer, this, separator, writeHeader);
    }

    default public void writeCSV(OutputStream outputStream, char separator, boolean writeHeader) {
        DataFrameWriter.writeCSV(outputStream, this, separator, writeHeader);
    }

    default public void writeCSV(File file, char separator, String headerPrefix) {
        DataFrameWriter.writeCSV(file, this, separator, headerPrefix);
    }

    default public void writeCSV(File file, char separator, String headerPrefix, boolean writeMetaFile) {
        DataFrameWriter.writeCSV(file, this, separator, headerPrefix, writeMetaFile);
    }

    default public void writeCSV(Writer writer, char separator, String headerPrefix) {
        DataFrameWriter.writeCSV(writer, this, separator, headerPrefix);
    }

    default public void writeCSV(OutputStream outputStream, char separator, String headerPrefix) {
        DataFrameWriter.writeCSV(outputStream, this, separator, headerPrefix);
    }

    default public void print() {
        DataFrameWriter.print(this);
    }

    default public void print(DataWriter dataWriter) {
        DataFrameWriter.print(this, dataWriter);
    }

    default public void print(WriteFormat writeFormat) {
        DataFrameWriter.print(this, writeFormat);
    }

    public Comparable getValue(int var1, int var2);

    public void setValue(int var1, int var2, Comparable var3);

    public boolean isNA(int var1, int var2);

    public DataFrame head(int var1);

    public DataFrame head();

    public DataFrame tail(int var1);

    public DataFrame tail();

    public void clear();
}

