/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.MapFunction;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.parser.Parser;
import de.unknownreality.dataframe.transform.ColumnDataFrameTransform;
import de.unknownreality.dataframe.transform.ColumnTransform;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataFrameColumn<T extends Comparable<T>, C extends DataFrameColumn<T, C>>
implements Iterable<T> {
    private static final Logger log = LoggerFactory.getLogger(DataFrameColumn.class);
    public static final String ERROR_APPENDING = "error appending value to column";
    private String name;
    private DefaultDataFrame dataFrame;
    private boolean dataFrameAppend = false;

    protected abstract C getThis();

    public abstract C setCapacity(int var1);

    public <R extends DataFrameColumn<?, R>> R transform(ColumnTransform<C, R> transformer) {
        return transformer.transform(this.getThis());
    }

    public DataFrame transform(ColumnDataFrameTransform<C> transformer) {
        return transformer.transform(this.getThis());
    }

    protected abstract void doSort(Comparator<T> var1);

    public final C sort(Comparator<T> comparator) {
        this.doSort(comparator);
        this.notifyDataFrameColumnChanged();
        return this.getThis();
    }

    protected abstract void doSort();

    public final C sort() {
        this.doSort();
        this.notifyDataFrameColumnChanged();
        return this.getThis();
    }

    public Double toDouble(int index) {
        T v = this.get(index);
        try {
            return ((Number)Number.class.cast(v)).doubleValue();
        }
        catch (Exception exception) {
            try {
                return Double.parseDouble(String.valueOf(v));
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract Parser<T> getParser();

    public abstract Class<T> getType();

    protected abstract void doSet(int var1, T var2);

    public final C set(int index, T value) {
        this.doSet(index, value);
        this.notifyDataFrameValueChanged(index);
        return this.getThis();
    }

    protected abstract void doMap(MapFunction<T> var1);

    public final C map(MapFunction<T> mapFunction) {
        this.doMap(mapFunction);
        this.notifyDataFrameColumnChanged();
        return this.getThis();
    }

    protected abstract void doReverse();

    public final C reverse() {
        this.doReverse();
        this.notifyDataFrameColumnChanged();
        return this.getThis();
    }

    public abstract T get(int var1);

    public abstract C copy();

    public abstract C copyEmpty();

    public abstract void clear();

    public abstract T[] toArray(T[] var1);

    public abstract Comparable[] toArray();

    public abstract List<T> asList();

    public abstract List<T> toList();

    public abstract boolean containsAll(Collection<?> var1);

    public abstract boolean contains(T var1);

    protected abstract boolean doAppend(T var1);

    public abstract boolean isValueValid(Comparable var1);

    public abstract <H> T getValueFromRow(Row<?, H> var1, H var2);

    public abstract T getValueFromRow(Row<?, ?> var1, int var2);

    public final boolean append(T value) {
        try {
            this.validateAppend();
        }
        catch (DataFrameException e) {
            log.warn(ERROR_APPENDING, (Throwable)e);
            return false;
        }
        return this.doAppend(value);
    }

    public final <H> boolean append(Row<?, H> row, H headerName) {
        try {
            this.validateAppend();
        }
        catch (DataFrameException e) {
            log.warn(ERROR_APPENDING, (Throwable)e);
            return false;
        }
        return this.doAppend(this.getValueFromRow(row, headerName));
    }

    public final boolean append(Row<?, ?> row, int index) {
        try {
            this.validateAppend();
        }
        catch (DataFrameException e) {
            log.warn(ERROR_APPENDING, (Throwable)e);
            return false;
        }
        return this.doAppend(this.getValueFromRow(row, index));
    }

    protected final boolean append(Object value) {
        try {
            return this.append((T)((Comparable)value));
        }
        catch (Exception e) {
            log.warn(ERROR_APPENDING, (Throwable)e);
            throw new DataFrameRuntimeException(ERROR_APPENDING, e);
        }
    }

    protected abstract boolean doAppendAll(Collection<? extends T> var1);

    public final boolean appendAll(Collection<? extends T> c) {
        try {
            this.validateAppend();
        }
        catch (DataFrameException e) {
            log.warn(ERROR_APPENDING, (Throwable)e);
            return false;
        }
        return this.doAppendAll(c);
    }

    protected abstract boolean doAppendNA();

    public final boolean appendNA() {
        try {
            this.validateAppend();
        }
        catch (DataFrameException e) {
            log.warn("error appending NA to column", (Throwable)e);
            return false;
        }
        return this.doAppendNA();
    }

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract boolean isNA(int var1);

    protected abstract void doSetNA(int var1);

    public final C setNA(int index) {
        this.doSetNA(index);
        this.notifyDataFrameValueChanged(index);
        return this.getThis();
    }

    public void validateAppend() throws DataFrameException {
        if (!this.dataFrameAppend && this.getDataFrame() != null) {
            throw new DataFrameException("doAppend can only be used if the column is not added to a data frame. use dataFrame.append()");
        }
    }

    public void notifyDataFrameValueChanged(int index) {
        if (this.dataFrame == null) {
            return;
        }
        this.dataFrame.notifyColumnValueChanged(this, index, (Comparable)this.get(index));
    }

    public void notifyDataFrameColumnChanged() {
        if (this.dataFrame == null) {
            return;
        }
        this.dataFrame.notifyColumnChanged(this);
    }

    protected void startDataFrameAppend() {
        this.dataFrameAppend = true;
    }

    protected void endDataFrameAppend() {
        this.dataFrameAppend = false;
    }

    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    protected void setDataFrame(DefaultDataFrame dataFrame) throws DataFrameException {
        if (dataFrame == null) {
            this.dataFrame = null;
            return;
        }
        if (!dataFrame.containsColumn(this)) {
            throw new DataFrameException("setDataFrame is only used internally. please use dataFrame.addColumn");
        }
        this.dataFrame = dataFrame;
    }
}

